/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.rabbit.RabbitConsumer;

public class RabbitAcker
implements MessageAcker {
    private Channel channel;
    private boolean autoAck;
    private int visitStatus = 0;
    private int ackStatus = 0;
    private RabbitConsumer.AckedCallBack ackedCallback;

    public RabbitAcker(Channel channel, boolean autoAck) {
        this.channel = channel;
        this.autoAck = autoAck;
    }

    protected void setAckedCallBack(RabbitConsumer.AckedCallBack ackedCallback) {
        this.ackedCallback = ackedCallback;
    }

    public boolean hasDone() {
        return this.visitStatus > 0;
    }

    @Override
    public synchronized void ack(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.ackStatus = 1;
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                this.channel.basicAck(deliveryTag, false);
                if (this.ackedCallback != null) {
                    this.ackedCallback.call();
                }
            }
            catch (IOException e) {
                throw new KDException(BosErrorCode.rabbitmqException, "can't ack the message " + deliveryTag, (Throwable)e);
            }
        }
    }

    private long toTag(String messageId) {
        return Long.parseLong(messageId);
    }

    @Override
    public synchronized void deny(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.ackStatus = 2;
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                LockSupport.parkNanos(500000000L);
                this.channel.basicReject(deliveryTag, true);
            }
            catch (IOException e) {
                throw new KDException(BosErrorCode.rabbitmqException, "can't deny the message " + deliveryTag, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void discard(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.ackStatus = 3;
        if (!this.autoAck) {
            long deliveryTag = this.toTag(messageId);
            try {
                this.channel.basicReject(deliveryTag, false);
            }
            catch (IOException e) {
                throw new KDException(BosErrorCode.rabbitmqException, "can't discard the message " + deliveryTag, (Throwable)e);
            }
        }
    }

    public boolean isDenied() {
        return this.ackStatus == 2;
    }

    public boolean isAcked() {
        return this.ackStatus == 1;
    }

    public boolean isDiscarded() {
        return this.ackStatus == 3;
    }
}

