/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import kd.bos.mq.broadcast.MessageReceive;
import kd.bos.mq.rabbit.RabbitAcker;

public class RabbitBroadcastConsumer
extends DefaultConsumer {
    public RabbitBroadcastConsumer(Channel channel) {
        super(channel);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        RabbitAcker acker = new RabbitAcker(this.getChannel(), false);
        String messageId = String.valueOf(envelope.getDeliveryTag());
        boolean isRedeliver = envelope.isRedeliver();
        try {
            MessageReceive.instance().onMessage(body);
            super.handleDelivery(consumerTag, envelope, properties, body);
            acker.ack(messageId);
        }
        catch (Exception e) {
            if (isRedeliver) {
                acker.discard(messageId);
            } else {
                acker.deny(messageId);
            }
            throw new RuntimeException(e);
        }
    }
}

