/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.init.MQInit;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.Config;
import kd.bos.mq.rabbit.PublisherChannels;
import kd.bos.mq.rabbit.RabbitPublisher;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionStrategy;
import org.apache.log4j.Logger;

public class RabbitFactory
extends MQFactory {
    private static Logger logger = Logger.getLogger(RabbitFactory.class);

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName) {
        if (region == null) {
            throw new KDException(BosErrorCode.rabbitmqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queueName});
        }
        MQInit.waitForMQFinishInit(region);
        String queueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        if (def == null) {
            throw new KDException(BosErrorCode.rabbitmqConfiguration, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        return this._createPublisher(region, queueRealName, def);
    }

    private MessagePublisher _createPublisher(String region, String queueName, QueueDef def) {
        Channel channel = Config.reusePublisherChannel() ? PublisherChannels.getChannel(region) : ChannelFactory.getChannel(region);
        boolean transactional = def.isTransactional();
        try {
            QueueManager.declareIfNeed(channel, region, queueName, def.getMaxQueueLength());
            if (!"schedule".equals(region)) {
                ConsumerSupport.setAcrossNodeConsume(region, queueName, def);
            }
            return new RabbitPublisher(channel, queueName, transactional, region);
        }
        catch (Error | Exception t) {
            logger.error((Object)"RabbitFactory.createSimplePublisher error", t);
            throw new KDException(t, BosErrorCode.rabbitmqException, new Object[]{"error when create publisher"});
        }
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        Channel channelNew = ChannelFactory.getChannel(region);
        return new RabbitPublisher(channelNew, realQueueName, false, region);
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef def, String appid) {
        MQInit.waitForMQFinishInit(region);
        String queueRealName = QueueManager.getRealQueueNameWithAppid(region, def.getName(), appid);
        QueueManager._$defineQueue(region, def, appid);
        return this._createPublisher(region, queueRealName, def);
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queue, PartitionStrategy partitionStrategy) {
        throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"can't createPartitionPublisher directly!"});
    }
}

