/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rabbit.RabbitConsumer;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.MQGrayManager;

public class RabbitMQGrayManager
implements MQGrayManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long messageCount(String region, String queueName) {
        try (Channel channel = ChannelFactory.getChannel(region);){
            long activeCounter = ConsumerStats.getActiveCount(queueName);
            long count = channel.messageCount(queueName);
            long l = count + activeCounter;
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException("Rabbitmq: query message count exception, queueName: " + queueName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long consumerCount(String region, String queueName) {
        try (Channel channel = ChannelFactory.getChannel(region);){
            long l = channel.consumerCount(queueName);
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException("Rabbitmq: query message consumer exception, queueName: " + queueName, e);
        }
    }

    @Override
    public void deleteQueue(String region, String queueName) {
        try (Channel channel = ChannelFactory.getChannel(region);){
            channel.queueDelete(queueName);
        }
        catch (Exception e) {
            ExceptionLogger.log("Rabbitmq: delete queue exception, queueName: " + queueName, e);
        }
    }

    @Override
    public Consumer registerConsumer(String region, String queueName, boolean autoAck, int concurrency, MessageConsumer messageConsumer, int maxQueueLength) {
        try {
            Channel channel = ChannelFactory.getChannel(region);
            RabbitConsumer standardConsumer = new RabbitConsumer(region, queueName, autoAck, concurrency, messageConsumer, maxQueueLength, channel);
            standardConsumer.start();
            return standardConsumer;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    @Override
    public void shutdown() {
    }
}

