/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.rocket.RocketRPCHook;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.remoting.RPCHook;

public class ProducerFactory {
    private static final String PRODUCER_TRACE_NAME = "RocketProducerFactory";
    private static final Map<String, MQProducer> appProducers = new ConcurrentHashMap<String, MQProducer>(8);
    private static final String MQ_ROCKET_SEND_TIMEOUT = "mq.rocketmq.send.timeout";
    private static final int MQ_ROCKET_SEND_TIMEOUT_DEFAULT = 30000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static MQProducer getProducer(String queueName, RocketInfo rocketInfo) {
        DefaultMQProducer producer;
        block18: {
            producer = (DefaultMQProducer)appProducers.get(queueName);
            try (TraceSpan span = Tracer.create((String)PRODUCER_TRACE_NAME, (String)"getProducer", (boolean)true);){
                span.addTag("queueName", queueName);
                span.addTag("host", rocketInfo.getHost());
                if (null != producer && producer.getDefaultMQProducerImpl().getServiceState() == ServiceState.RUNNING) break block18;
                Map<String, MQProducer> map = appProducers;
                synchronized (map) {
                    producer = (DefaultMQProducer)appProducers.get(queueName);
                    if (null == producer || producer.getDefaultMQProducerImpl().getServiceState() != ServiceState.RUNNING) {
                        producer = new DefaultMQProducer(ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), queueName), ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword()));
                        producer.setNamesrvAddr(rocketInfo.getHost());
                        producer.setSendMsgTimeout(Integer.getInteger(MQ_ROCKET_SEND_TIMEOUT, 30000).intValue());
                        producer.setMaxMessageSize(PublisherSupport.MQ_MESSAGE_PAYLOAD_VALUE);
                        producer.setRetryTimesWhenSendFailed(29);
                        producer.addRetryResponseCode(2);
                        producer.setMqClientApiTimeout(30000);
                        producer.start();
                        appProducers.put(queueName, (MQProducer)producer);
                    }
                }
            }
            catch (MQClientException e) {
                throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"ProducerFactory.getProducer can't get producer" + e.getMessage()});
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQProducer getProducer(String region, String queueName, RocketInfo rocketInfo) {
        DefaultMQProducer producer;
        block19: {
            String producerCacheEnable = System.getProperty("mq.rocketmq.producer.cache.enable", "true");
            boolean flag = Boolean.parseBoolean(producerCacheEnable);
            if (!flag) {
                return ProducerFactory.getProducer(queueName, rocketInfo);
            }
            producer = (DefaultMQProducer)appProducers.get(region);
            try (TraceSpan span = Tracer.create((String)PRODUCER_TRACE_NAME, (String)"getProducer", (boolean)true);){
                span.addTag("queueName", queueName);
                span.addTag("host", rocketInfo.getHost());
                if (null != producer && producer.getDefaultMQProducerImpl().getServiceState() == ServiceState.RUNNING) break block19;
                Map<String, MQProducer> map = appProducers;
                synchronized (map) {
                    producer = (DefaultMQProducer)appProducers.get(region);
                    if (null == producer || producer.getDefaultMQProducerImpl().getServiceState() != ServiceState.RUNNING) {
                        producer = new DefaultMQProducer(ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), queueName), ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword()));
                        producer.setNamesrvAddr(rocketInfo.getHost());
                        producer.setInstanceName(RocketmqFactory.getInstanceName((String)region));
                        producer.setSendMsgTimeout(Integer.getInteger(MQ_ROCKET_SEND_TIMEOUT, 30000).intValue());
                        producer.setMaxMessageSize(PublisherSupport.MQ_MESSAGE_PAYLOAD_VALUE);
                        producer.setRetryTimesWhenSendFailed(29);
                        producer.addRetryResponseCode(2);
                        producer.setMqClientApiTimeout(30000);
                        producer.start();
                        appProducers.put(region, (MQProducer)producer);
                    }
                }
            }
            catch (MQClientException e) {
                throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"ProducerFactory.getProducer can't get producer" + e.getMessage()});
            }
        }
        return producer;
    }

    public static String getRegionServerKey(String region) {
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        if (server != null) {
            return serverKey;
        }
        return "mq.server";
    }

    public static RPCHook getAclRPCHook(String accessKey, String secretKey) {
        if (StringUtils.isEmpty((String)accessKey) || StringUtils.isEmpty((String)secretKey)) {
            return new RocketRPCHook();
        }
        return new RocketRPCHook((RPCHook)new AclClientRPCHook(new SessionCredentials(accessKey, secretKey)));
    }

    public static String getTopicAndGroupName(String vhost, String queueName) {
        return (vhost + '_' + queueName).replace('.', '-');
    }
}

