/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.Broadcast;
import kd.bos.mq.broadcast.Configure;
import kd.bos.mq.broadcast.MessageReceive;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rocket.ConsumerFactory;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketMQTopicUtil;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.MQConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class RocketBroadcast
extends Broadcast {
    private static final String BROADCAST_REGION = "broadcast";
    private static final String BROADCAST_QUEUE = "broadcast_queue_" + Instance.getClusterName() + System.getProperty("mq.debug.queue.tag", "");
    private static final Log logger = LogFactory.getLog(RocketBroadcast.class);
    private static Map<String, MQConsumer> MQConsumerMap = new ConcurrentHashMap<String, MQConsumer>(8);

    private static void regist() {
        try {
            DefaultMQPushConsumer mqConsumer = (DefaultMQPushConsumer)MQConsumerMap.get(BROADCAST_QUEUE);
            if (mqConsumer != null && mqConsumer.getDefaultMQPushConsumerImpl().getServiceState() == ServiceState.RUNNING) {
                return;
            }
            mqConsumer = ConsumerFactory.getConsumer(BROADCAST_REGION, BROADCAST_QUEUE);
            String serverKey = ProducerFactory.getRegionServerKey(BROADCAST_REGION);
            RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), BROADCAST_QUEUE);
            RPCHook rpcHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
            RocketMQTopicUtil.createTopic(rocketInfo, groupAndTopicName, 1, rpcHook);
            RocketMQTopicUtil.createSubscriptionGroup(rocketInfo, groupAndTopicName, rpcHook);
            mqConsumer.setMessageModel(MessageModel.BROADCASTING);
            mqConsumer.registerMessageListener((msgs, context) -> {
                for (MessageExt msg : msgs) {
                    MessageReceive.instance().onMessage(msg.getBody());
                }
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            });
            mqConsumer.start();
            MQConsumerMap.put(BROADCAST_QUEUE, (MQConsumer)mqConsumer);
        }
        catch (MQClientException e) {
            ExceptionLogger.log("Can't regist consumer for RocketBroadcast ", e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't regist consumer for RocketBroadcast"});
        }
    }

    private static void regist(String appId) {
        DefaultMQPushConsumer broadcastConsumer = (DefaultMQPushConsumer)MQConsumerMap.get(appId);
        if (broadcastConsumer != null && broadcastConsumer.getDefaultMQPushConsumerImpl().getServiceState() == ServiceState.RUNNING) {
            return;
        }
        broadcastConsumer = ConsumerFactory.getConsumer(RocketBroadcast.getAppRegion(appId), RocketBroadcast.getBroadcastQueue(appId));
        try {
            String serverKey = ProducerFactory.getRegionServerKey(RocketBroadcast.getAppRegion(appId));
            RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), RocketBroadcast.getBroadcastQueue(appId));
            RPCHook rpcHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
            RocketMQTopicUtil.createTopic(rocketInfo, groupAndTopicName, 1, rpcHook);
            RocketMQTopicUtil.createSubscriptionGroup(rocketInfo, groupAndTopicName, rpcHook);
            broadcastConsumer.setMessageModel(MessageModel.BROADCASTING);
            broadcastConsumer.registerMessageListener((msgs, context) -> {
                for (MessageExt msg : msgs) {
                    MessageReceive.instance().onMessage(msg.getBody());
                }
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            });
            broadcastConsumer.start();
            MQConsumerMap.put(appId, (MQConsumer)broadcastConsumer);
        }
        catch (MQClientException e) {
            ExceptionLogger.log("Can't regist consumer for appid RocketBroadcast,appid:" + appId, e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't regist consumer for appid RocketBroadcast,appid:" + appId});
        }
    }

    private static final String getAppRegion(String appId) {
        return "broadcast_" + appId;
    }

    private static final String getBroadcastQueue(String appId) {
        return BROADCAST_QUEUE + '_' + appId;
    }

    @Override
    public void registerBroadcastConsumer() {
        RocketBroadcast.regist();
        try {
            if (!Instance.isAppSplit()) {
                return;
            }
            String[] appIds = Instance.getAppIds();
            if (appIds == null) {
                return;
            }
            Set<String> supportedAppids = Configure.getSupportBroadcastAppids();
            for (String appId : appIds) {
                if (!supportedAppids.contains(appId)) continue;
                RocketBroadcast.regist(appId);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"can't init RocketBroadcastConsumer"});
        }
    }

    @Override
    public void broadcastMessage(byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        try {
            String serverKey = ProducerFactory.getRegionServerKey(BROADCAST_REGION);
            RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
            DefaultMQProducer producer = (DefaultMQProducer)ProducerFactory.getProducer(BROADCAST_REGION, BROADCAST_QUEUE, rocketInfo);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), BROADCAST_QUEUE);
            Message rocketMessage = new Message(groupAndTopicName, "*", message);
            producer.send(rocketMessage);
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            logger.error(e);
            throw new KDException(e, BosErrorCode.rocketmqException, new Object[]{"boradcastMessage can't send " + e.getMessage()});
        }
    }

    @Override
    public void broadcastMessage(String appId, byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        if (!Configure.getSupportBroadcastAppids().contains(appId)) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"app " + appId + " not support broadcast"});
        }
        try {
            if (Instance.isAppSplit()) {
                String region = RocketBroadcast.getAppRegion(appId);
                String serverKey = ProducerFactory.getRegionServerKey(region);
                RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
                DefaultMQProducer rocketproducer = (DefaultMQProducer)ProducerFactory.getProducer(region, RocketBroadcast.getBroadcastQueue(appId), rocketInfo);
                String groupAndTopicName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), RocketBroadcast.getBroadcastQueue(appId));
                Message rocketMessage = new Message(groupAndTopicName, "*", message);
                rocketproducer.send(rocketMessage);
            } else {
                String serverKey = ProducerFactory.getRegionServerKey(BROADCAST_REGION);
                RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
                DefaultMQProducer rocketproducer = (DefaultMQProducer)ProducerFactory.getProducer(BROADCAST_REGION, BROADCAST_QUEUE, rocketInfo);
                String groupAndTopicName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), BROADCAST_QUEUE);
                Message rocketMessage = new Message(groupAndTopicName, "*", message);
                rocketproducer.send(rocketMessage);
            }
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            logger.error(e);
            throw new KDException(e, BosErrorCode.rocketmqException, new Object[]{"boradcastMessage can't send,appid " + appId + ",errorMessage" + e.getMessage()});
        }
    }

    private boolean broadcastDisable() {
        return Boolean.getBoolean("boradcast.disable");
    }
}

