/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import java.util.Map;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketConsumer;
import kd.bos.mq.rocket.RocketMQTopicUtil;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.remoting.RPCHook;

public class RocketQueueDeclare
implements QueueDeclare {
    @Override
    public void queueDeclare(String region, String queueRealName, boolean isDuration, Map<String, Object> args) {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        int queueNums = Integer.parseInt(System.getProperty("mq.rocketmq.topic.queuenums", "4"));
        boolean isSequential = def.isSequential();
        if (isSequential) {
            queueNums = 1;
        }
        String topic = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), queueRealName);
        RPCHook rpcHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
        RocketMQTopicUtil.createTopic(rocketInfo, topic, queueNums, rpcHook);
    }

    @Override
    public RocketConsumer getConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef, MessageConsumer mc) {
        int concurrency = QueueManager.getConcurrency(consumerDef);
        RocketConsumer consumer = new RocketConsumer(region, queueName, consumerDef.isAutoAck(), concurrency, mc, queueDef.getMaxQueueLength());
        return consumer;
    }
}

