/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.stat;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationUtil;

public class ConsumerStats {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("grayUpgrade", new DistributeCacheHAPolicy(true, false));
    private static boolean stat_enable = AppGroup.isGrayUpgrade();
    private static int expirationTime = 180;
    private static final String clusterName = Instance.getClusterName();
    private static final String totalCountName = "totalCount_";
    private static final String INACTIVENAME = "inactive_";

    public static void incrementActiveCount(String queueName, String messageId) {
        if (stat_enable) {
            cache.addToSet(ConsumerStats.getRealKey(queueName), new String[]{messageId}, expirationTime);
            cache.inc(ConsumerStats.getTotalCoutKey(queueName));
        }
    }

    public static void decrementActiveCount(String queueName, String messageId) {
        if (stat_enable) {
            cache.removeSetValues(ConsumerStats.getRealKey(queueName), new String[]{messageId});
        }
    }

    public static long getActiveCount(String queueName) {
        if (stat_enable) {
            return cache.getSetLength(ConsumerStats.getRealKey(queueName));
        }
        return 0L;
    }

    public static long getTotalCount(String queueName) {
        if (stat_enable) {
            try {
                return Long.parseLong((String)cache.get(ConsumerStats.getTotalCoutKey(queueName)));
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    private static String getRealKey(String queueName) {
        return INACTIVENAME + clusterName + "-" + queueName;
    }

    private static String getTotalCoutKey(String queueName) {
        return totalCountName + ConsumerStats.getRealKey(queueName);
    }

    static {
        try {
            ConfigurationUtil.observeBoolean((String)"mq.consumer.stat.enable", (boolean)false, value -> {
                stat_enable = value;
            });
            ConfigurationUtil.observeInteger((String)"mq.queue.stat.expiration.time", (int)180, value -> {
                expirationTime = value;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

