/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.MQGrayManager;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public abstract class AbstractMQGrayForMqInterfaceNotAvaible
implements MQGrayManager {
    private Map<String, AtomicLong> preTotalCountMap = new ConcurrentHashMap(2);
    private Map<String, AtomicInteger> waitTimesMap = new ConcurrentHashMap(2);
    private static final int NOTZERO = 999;

    @Override
    public long messageCount(String region, String queueName) {
        return this.getCount(queueName, 30);
    }

    @Override
    public long consumerCount(String region, String queueName) {
        return this.getCount(queueName, 60);
    }

    private long getCount(String queueName, int seconds) {
        AtomicInteger waittimes = this.waitTimesMap.computeIfAbsent(queueName, k -> new AtomicInteger(0));
        long activeCount = ConsumerStats.getActiveCount(queueName);
        if (activeCount > 0L) {
            waittimes.set(0);
            return activeCount;
        }
        long consumTotalCount = ConsumerStats.getTotalCount(queueName);
        AtomicLong preTotalCount = this.preTotalCountMap.computeIfAbsent(queueName, k -> new AtomicLong(0L));
        if (preTotalCount.get() != consumTotalCount) {
            preTotalCount.set(consumTotalCount);
            waittimes.set(0);
            return 999L;
        }
        if (waittimes.getAndIncrement() < seconds) {
            return 999L;
        }
        return 0L;
    }
}

