/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.WebPortUtil;

public class ConfigForInitConsumer {
    private static final String MQ_CONSUMER_INIT_KEY = "mq.consumer.register";
    private static final String MQ_CONSUMER_REGION_WHITELIST_KEY = "mq.consumer.register.region.whitelist";
    private static final String MQ_CONSUMER_CONCURRENCY_KEY = "mq.consumer.concurrency.config";
    private static boolean isShouldRegister = Boolean.parseBoolean(System.getProperty("mq.consumer.register", "true"));
    private static Map<String, Integer> consumerConcurrency = new HashMap<String, Integer>();
    private static Log logger = LogFactory.getLog(ConfigForInitConsumer.class);
    private static Set<String> whiteList = new HashSet<String>(2);

    private static void init() {
        ConfigurationUtil.observeChange((String)MQ_CONSUMER_INIT_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                boolean old = isShouldRegister;
                isShouldRegister = Boolean.parseBoolean(System.getProperty(ConfigForInitConsumer.MQ_CONSUMER_INIT_KEY, "true"));
                if (old && !isShouldRegister) {
                    ConfigForInitConsumer.stopConsumer();
                } else if (!old && isShouldRegister) {
                    this.startConsumer();
                }
            }

            private void startConsumer() {
            }
        });
        String whiteListStr = System.getProperty(MQ_CONSUMER_REGION_WHITELIST_KEY);
        if (whiteListStr != null && whiteListStr.trim().length() > 0) {
            String[] regions;
            for (String region : regions = whiteListStr.split(",|;")) {
                whiteList.add(region);
            }
        }
        ConfigurationUtil.observeChange((String)MQ_CONSUMER_CONCURRENCY_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                Map innerConsumerConcurrency = ConfigForInitConsumer.initConsumerConcurrency(System.getProperty(ConfigForInitConsumer.MQ_CONSUMER_CONCURRENCY_KEY));
                innerConsumerConcurrency.forEach((k, v) -> {
                    if (!v.equals(consumerConcurrency.get(k))) {
                        ConfigForInitConsumer.notifyUpdateConsumerConcurrency(k, v);
                    }
                });
                consumerConcurrency = innerConsumerConcurrency;
            }
        });
        consumerConcurrency = ConfigForInitConsumer.initConsumerConcurrency(System.getProperty(MQ_CONSUMER_CONCURRENCY_KEY));
    }

    private static void notifyUpdateConsumerConcurrency(String k, Integer v) {
        QueueManager.updateConsumer(k, v);
    }

    public static int getConcurrency(String region, String realQueueName, int defalut) {
        Integer currency = consumerConcurrency.get(region + realQueueName);
        return currency == null ? defalut : currency;
    }

    private static Map<String, Integer> initConsumerConcurrency(String propertyStr) {
        HashMap<String, Integer> consumerConcurrency = new HashMap<String, Integer>();
        if (propertyStr == null || propertyStr.trim().length() == 0) {
            return consumerConcurrency;
        }
        Properties p = new Properties();
        StringReader reader = new StringReader(propertyStr);
        try {
            p.load(reader);
            p.stringPropertyNames().forEach(key -> {
                String value = p.getProperty((String)key);
                String region = null;
                String queue = null;
                if (key.indexOf("#") > 0) {
                    String[] pairs = key.split("#");
                    region = pairs[0];
                    queue = pairs[1];
                } else {
                    int index = key.indexOf(46);
                    region = key.substring(0, index);
                    queue = key.substring(index + 1);
                }
                consumerConcurrency.put(region + QueueManager.getRealQueueName(region, queue), Integer.parseInt(value));
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return consumerConcurrency;
    }

    public static boolean needWaitingInitConsumer() {
        return !isShouldRegister;
    }

    public static boolean isConsumerEnable() {
        return isShouldRegister;
    }

    public static boolean isNotInitConsumer() {
        return WebPortUtil.isWebNode() && !Instance.isWebMserviceInOne();
    }

    public static boolean isConsumerRegionEnable(String region) {
        if (whiteList.isEmpty()) {
            return true;
        }
        return whiteList.contains(region);
    }

    private static void stopConsumer() {
        System.setProperty("mq.consumer.status", "has stopped by [mq.consumer.register],must restart mservice to restart consumer");
        QueueManager.getConsumers().forEach((k, v) -> {
            Consumer consumer = (Consumer)v;
            consumer.$$stop();
        });
    }

    static {
        ConfigForInitConsumer.init();
    }
}

