/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.instance.Instance;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXMesPubFactory;
import kd.bos.mq.dlx.DLXStrategy;
import kd.bos.mq.dlx.MessageRecord;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketAcker;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageCommonAcker;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.TimeCacheMap;
import kd.bos.mq.support.TranscationSupport;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import org.apache.rocketmq.client.producer.MQProducer;

public class ConsumerManager {
    private static final Counter noRequestContextCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.noRequestContextCounter");
    private static final Counter decodeMessageErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.decodeMessageErrorCounter");
    private static final Counter handlerMessagerErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerOnMessagerErrorCounter");
    private static final Counter handlerMessagerTranscationRollBackCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRollBackCounter");
    private static final Counter handlerMessagerTranscationRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRepeateCounter");
    private static final Counter handlerMessagerRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerRepeateCounter");
    private static final Counter consumerounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.Counter");
    private static final Counter activeCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.activeConsumers");
    private static TimeCacheMap<AtomicInteger> messageRepeatTimes = new TimeCacheMap(300);

    public static Counter getConsumerounter() {
        return consumerounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void innerHandleDelivery(MessageCommonAcker acker, MessageConsumer mc, String region, String queue, String messageId, int reconsumeTimes, byte[] body, String topic) {
        Message message;
        boolean isRetry = reconsumeTimes > 0;
        try {
            message = ConsumerManager.toMessage(body);
        }
        catch (Exception e) {
            acker.discard(messageId);
            decodeMessageErrorCounter.inc();
            ExceptionLogger.log("MQError:toMessage exception, auto discard, queue=" + queue + ",messageId=" + messageId, e);
            return;
        }
        if (ConsumerManager.renewDelay(messageId, message, acker, region, topic)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)message.getKdtxId())) {
            ConsumerManager._handleDtxDelivery(mc, isRetry, region, queue, messageId, message, acker);
            return;
        }
        long messageInnerId = message.getInnerId();
        if (messageInnerId != 0L) {
            AtomicInteger ai = messageRepeatTimes.get(messageInnerId);
            if (ai == null) {
                ai = new AtomicInteger(0);
                messageRepeatTimes.put(messageInnerId, ai);
            }
            if (ai.getAndIncrement() > 100) {
                acker.discard(messageId);
                messageRepeatTimes.remove(messageInnerId);
                handlerMessagerRepeateCounter.inc();
                ExceptionLogger.log("MQError:Repeat send message too many times, auto discard, messageId=" + messageId + ",queue=" + queue);
                return;
            }
        }
        try {
            ThreadLifeCycleManager.start();
            ConsumerManager._handleDelivery(mc, reconsumeTimes, region, queue, messageId, message, acker, topic);
        }
        catch (Exception t) {
            if (!acker.hasDone()) {
                int tryTimes = TranscationSupport.instance().tryTimes(String.valueOf(message.getInnerId()));
                if (tryTimes > 30) {
                    acker.discard(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception,try times >30, auto discard, messageId=" + messageId, t);
                } else {
                    ConsumerManager.applyWait(tryTimes);
                    acker.deny(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
                }
            } else {
                ExceptionLogger.log("MQError:handleDelivery uncatched exception, messageId=" + messageId, t);
            }
        }
        finally {
            ThreadLifeCycleManager.end();
            if (!acker.isDenied()) {
                messageRepeatTimes.remove(messageInnerId);
            }
        }
    }

    private static boolean renewDelay(String messageId, Message message, MessageCommonAcker acker, String region, String topic) {
        int remainSeconds = (int)((message.getStartDeliverTime() - System.currentTimeMillis()) / 1000L);
        if (message.getStartDeliverTime() > 0L && remainSeconds > 0) {
            try {
                MetaTime metaTime = DelayControlManager.selectMaxMetaTime(remainSeconds);
                byte[] bytes = MessageSerde.get().encode(message);
                String serverKey = ProducerFactory.getRegionServerKey(region);
                RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
                MQProducer producer = ProducerFactory.getProducer(region, topic, rocketInfo);
                org.apache.rocketmq.common.message.Message rocketMessage = new org.apache.rocketmq.common.message.Message(topic, "*", bytes);
                rocketMessage.setDelayTimeLevel(metaTime.getLevel());
                producer.send(rocketMessage);
                acker.discard(messageId);
            }
            catch (Exception e) {
                acker.deny(messageId);
                ExceptionLogger.log("publishDelayMessageConfirmModel for queue " + topic + " error ", e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _handleDtxDelivery(MessageConsumer mc, boolean isRetry, String region, String queue, String messageId, Message message, MessageCommonAcker acker) {
        boolean isManual = false;
        boolean dbTransEnd = true;
        DBRoute dbRoute = DBRoute.of((String)message.getRouteKey());
        try {
            ThreadLifeCycleManager.start();
            boolean b = ConsumerManager.createTraceAndRequestContext(message);
            if (!b) {
                acker.discard(messageId);
                KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
                noRequestContextCounter.inc();
                return;
            }
            boolean isReceived = KdtxSupport.isReceived(dbRoute, message.getKdtxId(), message.getSeq());
            if (!isReceived) {
                try {
                    KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                }
                catch (Exception e) {
                    acker.deny(messageId);
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "MQError:message update receive statue error, will requeue", true);
                    noRequestContextCounter.inc();
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
                    if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                        if (isManual) {
                            KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                        }
                        KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
                    }
                    ThreadLifeCycleManager.end();
                    return;
                }
            } else if (!isRetry) {
                isManual = KdtxSupport.isManual(message.getKdtxId(), message.getSeq());
                if (!isManual) {
                    acker.discard(messageId);
                    return;
                }
            } else if (KdtxSupport.mqSecondCompensate(message.getKdtxId(), message.getSeq())) {
                acker.discard(messageId);
                return;
            }
            if (message.getKdtxId().equals(message.getTranscationTag())) {
                if (TranscationSupport.instance().isRollBack(message.getTranscationTag())) {
                    acker.isDiscarded();
                    return;
                }
                if (!TranscationSupport.instance().existXid(message.getRouteKey(), message.getTranscationTag())) {
                    acker.isDiscarded();
                    dbTransEnd = false;
                    return;
                }
            }
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), String.format("message[isReceived:%s,isManual:%s] start execute", isReceived, isManual), false);
            RequestContext rc = RequestContext.get();
            if (ConsumerManager.isforbiddenTenantCode(rc.getTenantCode())) {
                LockSupport.parkNanos(1000000000L);
                acker.deny(messageId);
                return;
            }
            if (DLXConfig.isSendDLX(message.getRequestContext())) {
                message.setDLXMessage(true);
                DLXMesPubFactory.getDLXMessagePublisher().sendMessage(region, queue, message, messageId, acker);
                return;
            }
            ConsumerStats.incrementActiveCount(queue, messageId);
            ConsumerManager.doTraceAndConsume(mc, isRetry, messageId, message, acker);
            ConsumerStats.decrementActiveCount(queue, messageId);
            if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
                MessageRecord.update(2, message.getInnerId());
            }
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                ConsumerManager.applyWait(1);
                acker.deny(messageId);
                KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "common exception auto deny,errorMsg:" + t.getMessage(), true);
            }
            ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
        }
        finally {
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
            if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                if (isManual) {
                    KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                }
                KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
            }
            ThreadLifeCycleManager.end();
        }
    }

    private static void _handleDelivery(MessageConsumer mc, int reconsumeTimes, String region, String queue, String messageId, Message message, MessageCommonAcker acker, String topic) {
        boolean b = ConsumerManager.createTraceAndRequestContext(message);
        if (!b) {
            acker.discard(messageId);
            ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
            noRequestContextCounter.inc();
            return;
        }
        RequestContext rc = RequestContext.get();
        if (ConsumerManager.isforbiddenTenantCode(rc.getTenantCode())) {
            LockSupport.parkNanos(1000000000L);
            acker.deny(messageId);
            return;
        }
        if (DLXConfig.isSendDLX(message.getRequestContext())) {
            message.setDLXMessage(true);
            DLXMesPubFactory.getDLXMessagePublisher().sendMessage(region, queue, message, messageId, acker);
            return;
        }
        if (!ConsumerManager.isTransactionSubmit(mc, messageId, message, acker, reconsumeTimes, region, topic)) {
            return;
        }
        ConsumerStats.incrementActiveCount(queue, messageId);
        ConsumerManager.doTraceAndConsume(mc, reconsumeTimes > 0, messageId, message, acker);
        ConsumerStats.decrementActiveCount(queue, messageId);
        if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
            MessageRecord.update(2, message.getInnerId());
        }
    }

    private static boolean isforbiddenTenantCode(String tenantCode) {
        if (Instance.isPausedServiceByMonitor()) {
            return true;
        }
        String fbStr = System.getProperty("mq.consume.forbidden.tenantcodes");
        if (fbStr == null) {
            return false;
        }
        String[] fbTenantCodes = fbStr.split(",|;");
        if (fbTenantCodes == null) {
            return false;
        }
        for (String fbcode : fbTenantCodes) {
            if (!tenantCode.equalsIgnoreCase(fbcode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTransactionSubmit(MessageConsumer mc, String messageId, Message message, MessageCommonAcker acker, int reconsumerTimes, String region, String topic) {
        String xid = message.getTranscationTag();
        if (xid != null) {
            boolean existXid;
            int loop = 0;
            int max = 3;
            do {
                existXid = TranscationSupport.instance().existXid(message.getRouteKey(), xid);
                if (max == ++loop) break;
                ConsumerManager.applyWait(loop);
            } while (!existXid);
            if (!existXid) {
                ConsumerManager.waitDeal(messageId, message, acker, xid, reconsumerTimes, region, topic);
                return false;
            }
            String messageRouteKey = message.getRouteKey();
            String consumeRouteKey = mc.getRouteKey();
            if (consumeRouteKey == null) {
                consumeRouteKey = messageRouteKey;
            }
            if (TranscationSupport.instance().existConsumedId(consumeRouteKey, xid)) {
                acker.discard(messageId);
                handlerMessagerTranscationRepeateCounter.inc();
                return false;
            }
            String _consumeRouteKey = consumeRouteKey;
            acker.setAckedCallBack(() -> {
                try {
                    TranscationSupport.instance().insertConsumed(_consumeRouteKey, xid);
                    TranscationSupport.instance().deleteXid(messageRouteKey, xid);
                }
                catch (Exception e) {
                    ExceptionLogger.log("mq TranscationSupport error of acktion" + messageId, e);
                }
            });
        }
        return true;
    }

    private static void waitDeal(String messageId, Message message, MessageCommonAcker acker, String xid, int reconsumerTimes, String region, String topic) {
        if (message.getRetryTimes() != -1) {
            ConsumerManager.delayStrategy(messageId, message, acker, reconsumerTimes, region, topic);
        } else {
            ConsumerManager.timesStrategy(messageId, message, acker, xid);
        }
    }

    private static void delayStrategy(String messageId, Message message, MessageCommonAcker acker, int reconsumerTimes, String region, String topic) {
        if (reconsumerTimes >= 14) {
            acker.discard(messageId);
        } else {
            acker.deny(messageId);
        }
    }

    private static void timesStrategy(String messageId, Message message, MessageCommonAcker acker, String xid) {
        int tryTimes = TranscationSupport.instance().tryTimes(xid);
        if (ConsumerManager.isMessageTimeout(message)) {
            acker.discard(messageId);
            handlerMessagerTranscationRollBackCounter.inc();
        } else {
            ConsumerManager.applyWait(tryTimes);
            acker.deny(messageId);
        }
    }

    private static boolean isMessageTimeout(Message message) {
        long timeout = (long)Integer.parseInt(System.getProperty("mq.trasncation.message.waittime", "300")) * 1000L;
        return System.currentTimeMillis() - message.getMessageTime() > timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTraceAndConsume(MessageConsumer mc, boolean isRetry, String messageId, Message message, MessageCommonAcker acker) {
        try (TraceSpan span = Tracer.create((String)"MQConsumer", (String)"onMessage", (boolean)true);){
            span.addTag("messageId", messageId);
            span.addTag("resent", Boolean.toString(isRetry));
            try {
                activeCounter.inc();
                mc.onMessage(message.getBody(), messageId, isRetry, acker);
                if (acker instanceof RocketAcker) {
                    ((RocketAcker)acker).setBizInvoked(true);
                }
                if (!acker.hasDone()) {
                    acker.ack(messageId);
                }
            }
            catch (Exception t) {
                if (!acker.hasDone()) {
                    acker.discard(messageId);
                    handlerMessagerErrorCounter.inc();
                    ExceptionLogger.log("MQError:onMessage uncatched exception, auto discard, messageId=" + messageId, t);
                } else {
                    ExceptionLogger.log("MQError:onMessage uncatched exception, messageId=" + messageId, t);
                }
            }
            finally {
                activeCounter.dec();
            }
        }
    }

    private static boolean createTraceAndRequestContext(Message message) {
        RequestContext rc = message.getRequestContext();
        if (rc == null) {
            return false;
        }
        String traceId = TraceIdUtil.createTraceIdString();
        SetThreadName.setTraceId((String)traceId);
        rc.setTraceId(traceId);
        RequestContextCreator.restoreForMQ((RequestContext)rc);
        return true;
    }

    private static void applyWait(int tryTimes) {
        if (tryTimes <= 1) {
            LockSupport.parkNanos(100000000L);
        } else {
            LockSupport.parkNanos(1000000000L * (long)tryTimes);
        }
    }

    private static Message toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }
}

