/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;

public class HessianMessageSerde
extends MessageSerde {
    public static final HessianMessageSerde instance = new HessianMessageSerde();

    @Override
    public byte[] encode(Message message) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output h2o = new Hessian2Output((OutputStream)os);
        try {
            h2o.startMessage();
            h2o.writeObject((Object)message);
            h2o.completeMessage();
            h2o.close();
            byte[] buffer = os.toByteArray();
            os.close();
            return buffer;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"can't encode message."});
        }
    }

    @Override
    public Message decode(byte[] bytes) {
        Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(bytes));
        try {
            h2i.startMessage();
            return (Message)h2i.readObject();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"can't decode message."});
        }
    }
}

