/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.instance.Instance;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.failover.FailoverPublisherWrapper;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MQCreateFactory
extends MQFactory {
    private static ExtensionFactory<MQFactory> mqExtensionFactory = ExtensionFactory.getExtensionFacotry(MQFactory.class);
    private static final String FAKE_MQ = "fakemq";

    @Override
    public MessagePublisher createSimplePublisher(String region, String queue) {
        if (region == null) {
            throw new KDException(BosErrorCode.rocketmqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queue});
        }
        String type = QueueManager.getMQType(region);
        if (Instance.isLightWeightDeploy()) {
            type = FAKE_MQ;
        }
        MessagePublisher originPublisher = ((MQFactory)mqExtensionFactory.getExtension(type)).createSimplePublisher(region, queue);
        if (FailoverConfig.MQ_FAILOVER_ENABLE && !region.equals("demo")) {
            String failoverMqType = FailoverConfig.getMQType(region);
            String queueRealName = QueueManager.getRealQueueName(region, queue);
            MessagePublisher failoverPublisher = ((MQFactory)mqExtensionFactory.getExtension(failoverMqType)).createSimplePublisher(region, queue);
            return new FailoverPublisherWrapper(region, queueRealName, originPublisher, failoverPublisher);
        }
        return originPublisher;
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef queueDef, String appid) {
        if (region == null) {
            throw new KDException(BosErrorCode.rocketmqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queueDef});
        }
        String type = QueueManager.getMQType(region);
        if (Instance.isLightWeightDeploy()) {
            type = FAKE_MQ;
        }
        MessagePublisher originPublisher = ((MQFactory)mqExtensionFactory.getExtension(type)).$createPublisherWithAppid(region, queueDef, appid);
        if (FailoverConfig.MQ_FAILOVER_ENABLE && !region.equals("demo")) {
            String failoverMqType = FailoverConfig.getMQType(region);
            String queueRealName = QueueManager.getRealQueueNameWithAppid(region, queueDef.getName(), appid);
            MessagePublisher failoverPublisher = ((MQFactory)mqExtensionFactory.getExtension(failoverMqType)).$createPublisherWithAppid(region, queueDef, appid);
            return new FailoverPublisherWrapper(region, queueRealName, originPublisher, failoverPublisher);
        }
        return originPublisher;
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        String type = QueueManager.getMQType(region);
        if (Instance.isLightWeightDeploy()) {
            type = FAKE_MQ;
        }
        MessagePublisher originPublisher = ((MQFactory)mqExtensionFactory.getExtension(type)).$createPublisherWithRealQueueName(region, realQueueName);
        if (FailoverConfig.MQ_FAILOVER_ENABLE && !region.equals("demo")) {
            String failoverMqType = FailoverConfig.getMQType(region);
            MessagePublisher failoverPublisher = ((MQFactory)mqExtensionFactory.getExtension(failoverMqType)).$createPublisherWithRealQueueName(region, realQueueName);
            return new FailoverPublisherWrapper(region, realQueueName, originPublisher, failoverPublisher);
        }
        return originPublisher;
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queue, PartitionStrategy partitionStrategy) {
        if (region == null) {
            throw new KDException(BosErrorCode.mqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queue});
        }
        String type = QueueManager.getMQType(region);
        if (Instance.isLightWeightDeploy()) {
            type = FAKE_MQ;
        }
        MessagePublisher originPublisher = ((MQFactory)mqExtensionFactory.getExtension(type)).createPartitionPublisher(region, queue, partitionStrategy);
        if (FailoverConfig.MQ_FAILOVER_ENABLE && !region.equals("demo")) {
            String failoverMqType = FailoverConfig.getMQType(region);
            String queueRealName = QueueManager.getRealQueueName(region, queue);
            MessagePublisher failoverPublisher = ((MQFactory)mqExtensionFactory.getExtension(failoverMqType)).createPartitionPublisher(region, queue, partitionStrategy);
            return new FailoverPublisherWrapper(region, queueRealName, originPublisher, failoverPublisher);
        }
        return originPublisher;
    }
}

