/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import kd.bos.context.RequestTimeoutContext;
import kd.bos.govern.timeout.TimeoutHandle;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class MessageConsumerWrapper
implements MessageConsumer {
    private static final String CONSUME_TIMEOUT_ENABLE_KEY = "mq.consumer.consume.timeout.enable";
    private static final String CONSUME_TIMEOUT_KEY = "mq.consumer.consume.timeout";
    public static int CONSUME_TIMEOUT_VALUE = 3600000;
    private MessageConsumer messageConsumer;

    public MessageConsumerWrapper(MessageConsumer messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    @Override
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        boolean consumeTimeoutEnable = "true".equals(System.getProperty(CONSUME_TIMEOUT_ENABLE_KEY, "false"));
        if (consumeTimeoutEnable) {
            try (TimeoutHandle timeoutHandle = TimeoutHandleFactory.get();){
                timeoutHandle.start(new RequestTimeoutContext("mqConsumerTimeout", "mqConsumer", (long)CONSUME_TIMEOUT_VALUE));
                this.messageConsumer.onMessage(message, messageId, resend, acker);
            }
        } else {
            this.messageConsumer.onMessage(message, messageId, resend, acker);
        }
    }

    @Override
    public String getRouteKey() {
        return this.messageConsumer.getRouteKey();
    }

    static {
        CONSUME_TIMEOUT_VALUE = ConfigurationUtil.getInteger((String)CONSUME_TIMEOUT_KEY, (Integer)CONSUME_TIMEOUT_VALUE);
        ConfigurationUtil.observeChange((String)CONSUME_TIMEOUT_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                CONSUME_TIMEOUT_VALUE = Integer.getInteger(MessageConsumerWrapper.CONSUME_TIMEOUT_KEY, CONSUME_TIMEOUT_VALUE);
            }
        });
    }
}

