/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TimeCacheMap<T> {
    private Map<Object, VItem> table = new ConcurrentHashMap<Object, VItem>();
    private long expirationMillis;
    private int maxSize = 1000;

    public TimeCacheMap(int expirationSecs) {
        this.expirationMillis = expirationSecs * 1000;
    }

    public T get(Object key) {
        VItem v = this.table.get(key);
        if (v != null) {
            if (System.currentTimeMillis() - v.stime > this.expirationMillis) {
                this.table.remove(key);
                return null;
            }
            return (T)v.o;
        }
        return null;
    }

    public void put(Object key, T value) {
        if (this.table.size() > this.maxSize) {
            this.cleanup();
        }
        this.table.put(key, new VItem(value));
    }

    public Object remove(Object key) {
        return this.table.remove(key);
    }

    public void cleanup() {
        this.table.clear();
    }

    private class VItem {
        private long stime;
        private T o;

        VItem(T o) {
            this.o = o;
            this.stime = System.currentTimeMillis();
        }
    }
}

