/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.dynamic;

import com.rabbitmq.client.Channel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.dynamic.AbstractDynamicQueueManager;

public class DynamicRabbitQueueManager
extends AbstractDynamicQueueManager {
    @Override
    public boolean deleteQueue(String queueName) {
        try {
            String realName = QueueManager.getRealQueueName(this.region, queueName);
            try (Channel channel = ChannelFactory.getChannel(this.region);){
                channel.queueDelete(realName);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.mqException, "deleteQueue:" + queueName, (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean deleteQueueByRealName(String realQueueName) {
        try (Channel channel = ChannelFactory.getChannel(this.region);){
            channel.queueDelete(realQueueName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.mqException, "deleteQueue:" + realQueueName, (Throwable)e);
        }
        return true;
    }
}

