/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.dynamic;

import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketConsumer;
import kd.bos.mq.rocket.RocketMQTopicUtil;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.dynamic.AbstractDynamicQueueManager;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.remoting.RPCHook;

public class DynamicRocketQueueManager
extends AbstractDynamicQueueManager {
    private static final Log LOGGER = LogFactory.getLog(DynamicRocketQueueManager.class);

    @Override
    public boolean deleteQueue(String queueName) {
        String realQueueName = QueueManager.getRealQueueName(this.region, queueName);
        return this.deleteQueueByRealName(realQueueName);
    }

    @Override
    public boolean deleteQueueByRealName(String realQueueName) {
        try {
            String serverKey = ProducerFactory.getRegionServerKey(this.region);
            RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
            String topicAndGroupName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), realQueueName);
            RPCHook rpcHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
            Map<String, Object> consumerMap = QueueManager.getConsumers();
            if (consumerMap.containsKey(this.region + realQueueName)) {
                RocketConsumer consumer = (RocketConsumer)consumerMap.get(this.region + realQueueName);
                consumer.$$stop();
            }
            RocketMQTopicUtil.deleteSubscriptionGroup(rocketInfo, topicAndGroupName, rpcHook);
            LOGGER.info("deleteSubscriptionGroup:{} success", (Object)topicAndGroupName);
            RocketMQTopicUtil.deleteTopic(rocketInfo, topicAndGroupName, rpcHook);
            LOGGER.info("deleteQueue:{} success", (Object)realQueueName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.mqException, "deleteQueue:" + realQueueName, (Throwable)e);
        }
        return true;
    }
}

