/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.partition.BroadcastConsumer;
import kd.bos.mq.support.partition.BroadcastConsumerWrapper;
import kd.bos.mq.support.partition.BroadcastResType;
import kd.bos.mq.support.partition.QueueMetaManager;
import kd.bos.mq.support.partition.ZKQueueManager;
import kd.bos.util.HttpClientUtils;

public class BroadcastConsumerHttp
implements BroadcastConsumer {
    private static final Log logger = LogFactory.getLog(BroadcastConsumerHttp.class);
    private static final String URL = "monitor/goldeye/mqparitionmanage";

    @Override
    public String getName() {
        return "http";
    }

    @Override
    public BroadcastResType broadRegisterConsumer(String region, String queueName, String realQueueName, String appId) {
        List<BroadcastConsumerWrapper.ServiceInfo> targetServiceInfoList;
        int total = 0;
        int success = 0;
        if (!Instance.isAppSplit()) {
            targetServiceInfoList = BroadcastConsumerWrapper.getAllServiceInfoList();
        } else {
            targetServiceInfoList = BroadcastConsumerWrapper.getServiceInfoListByAppId(appId);
            if (targetServiceInfoList == null) {
                return BroadcastResType.NONE;
            }
        }
        for (BroadcastConsumerWrapper.ServiceInfo node : targetServiceInfoList) {
            try {
                String nodeIp = node.getIp();
                String monitorPort = node.getMonitorPort();
                ++total;
                String consumerMetaStoreType = QueueMetaManager.getConsumerMetaStoreType();
                if (consumerMetaStoreType.equals("zookeeper") && ZKQueueManager.existMqConsumer(nodeIp, realQueueName)) {
                    ++success;
                    continue;
                }
                HashMap<String, String> header = new HashMap<String, String>();
                header.put(Instance.getClusterName() + "MSPTrOoNxEy", Instance.getClusterName() + "NSaAtRaAsShUaNNY");
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("region", region);
                body.put("queueName", queueName);
                body.put("realQueueName", realQueueName);
                body.put("appId", appId);
                String response = HttpClientUtils.get((String)String.format("http://%s:%s/%s", nodeIp, monitorPort, URL), header, body);
                if (response != null && JSON.parseObject((String)response).getInteger("code") == 0) {
                    ++success;
                    continue;
                }
                logger.error("broadRegisterMqConsumer for ip:{} ,realQueueName:{} fail", (Object)nodeIp, (Object)realQueueName);
            }
            catch (Exception e) {
                logger.error("broadRegisterMqConsumer node [{}] fail", (Object)node.toString());
            }
        }
        if (total != 0 && total == success) {
            return BroadcastResType.ALL;
        }
        if (total == 0 || success == 0) {
            return BroadcastResType.NONE;
        }
        return BroadcastResType.ANYONE;
    }
}

