/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.BroadcastConsumer;
import kd.bos.mq.support.partition.ZKQueueManager;
import kd.bos.util.StringUtils;

public class QueueMetaManager {
    private static Log logger = LogFactory.getLog(QueueMetaManager.class);
    private static final String QUEUE_META_DCID = "mqtx-queuemeta";
    private static final String LOCK_KEY = "QueueMetaManager-persistenceQueueMeta";
    private static final String MC_API_GET_MC_DATA = "/kapi/app/mc/DataSaveGetService";
    private static final String MC_API_SET_MC_DATA = "/kapi/app/mc/DataSaveSetService";
    private static final Set<String> queueMetaCache = new HashSet<String>();
    private static ScheduledExecutorService ses = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r);
        thread.setName("QueueMetaManager Scheduled");
        thread.setDaemon(true);
        return thread;
    });

    private QueueMetaManager() {
    }

    public static void startQueueMetaManage() {
        ses.schedule(QueueMetaManager::restoreQueueMeta, 90L, TimeUnit.SECONDS);
    }

    private static void restoreQueueMeta() {
        BroadcastConsumer broadcastConsumer = (BroadcastConsumer)ExtensionFactory.getExtensionFacotry(BroadcastConsumer.class).getExtension("http");
        Object rs = QueueMetaManager.getQueueMeta("");
        if (rs instanceof List) {
            List queueMetas = (List)rs;
            for (Object queueMeta : queueMetas) {
                String[] split = ((String)queueMeta).split("@#");
                String region = split[0];
                String queueName = split[1];
                String appId = split[2];
                String originQueueRealName = QueueManager.getRealQueueName(region, queueName);
                QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, originQueueRealName);
                if (def == null || ZKQueueManager.existQueueMeta((String)queueMeta)) continue;
                String queueNameWithAppId = queueName + "." + appId;
                String realQueueName = QueueManager.getRealQueueName(region, queueNameWithAppId);
                try {
                    broadcastConsumer.broadRegisterConsumer(region, queueName, realQueueName, appId);
                    ZKQueueManager.saveMqQueueMeta(region, queueName, appId, realQueueName);
                }
                catch (Exception e) {
                    logger.error("restore queue {} fail", (Object)realQueueName, (Object)e);
                }
            }
        }
    }

    public static String getConsumerMetaStoreType() {
        return System.getProperty("mq.partition.consumer.store.type", "maxnotify");
    }

    public static void persistenceQueueMeta(String queueMeta) {
        if (!queueMetaCache.contains(queueMeta)) {
            HashMap<String, String> map = new HashMap<String, String>(3);
            map.put("DCID", QUEUE_META_DCID);
            map.put("key", queueMeta);
            map.put("value", queueMeta);
            try {
                MCApiUtil.getMCAPIInfo((String)MC_API_SET_MC_DATA, (boolean)true, null, map);
            }
            catch (KDException e) {
                logger.error("persistenceMetaQueue for {} error,errorMessage:{}", (Object)queueMeta, (Object)e.getArgs());
            }
            catch (Exception e) {
                logger.error("persistenceMetaQueue for {} error,errorMessage:{}", (Object)queueMeta, (Object)e.getMessage());
            }
            queueMetaCache.add(queueMeta);
        }
    }

    public static Object getQueueMeta(String key) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("DCID", QUEUE_META_DCID);
        if (StringUtils.isNotEmpty((String)key)) {
            map.put("key", key);
        }
        Object obj = null;
        try {
            obj = MCApiUtil.getMCAPIInfo((String)MC_API_GET_MC_DATA, (boolean)true, null, map);
        }
        catch (KDException e) {
            if (!"626".equals(e.getErrorCode().getCode())) {
                logger.error("The apiMetadata's signature query db error,errorMessage:" + e.getArgs());
            }
        }
        catch (Exception e) {
            logger.error("The apiMetadata's signature query db error,errorMessage:" + e.getMessage());
        }
        return obj;
    }
}

