/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket.server;

import com.tongweb.web.websocket.server.UpgradeUtil;
import com.tongweb.web.websocket.server.WsMappingResult;
import com.tongweb.web.websocket.server.WsServerContainer;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.GenericFilter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WsFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    private transient WsServerContainer sc;

    public void init() throws ServletException {
        this.sc = (WsServerContainer)((Object)this.getServletContext().getAttribute("javax.websocket.server.ServerContainer"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.sc.areEndpointsRegistered() && UpgradeUtil.isWebSocketUpgradeRequest(request, response)) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            String pathInfo = req.getPathInfo();
            String path = pathInfo == null ? req.getServletPath() : req.getServletPath() + pathInfo;
            WsMappingResult mappingResult = this.sc.findMapping(path);
            if (mappingResult == null) {
                chain.doFilter(request, response);
            } else {
                UpgradeUtil.doUpgrade(this.sc, req, resp, mappingResult.getConfig(), mappingResult.getPathParams());
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

