/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.embedjetty;

import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.util.concurrent.locks.LockSupport;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.instance.Instance;
import kd.bos.metric.MetricSystem;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.msgjet.websocket.jetty.MsgWebSocketHandler;
import kd.bos.resource.balancer.Configs;
import kd.bos.service.bootstrap.BootServer;
import kd.bos.service.web.WebResourceUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.WebPortUtil;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;

public class EmbedJettyServer
implements BootServer {
    private static Logger logger = Logger.getLogger(EmbedJettyServer.class);

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static void disableMethods(ServletContextHandler servletContextHandler, String[] methods) {
        SecurityHandler securityHandler = servletContextHandler.getSecurityHandler();
        if (securityHandler == null) {
            securityHandler = new ConstraintSecurityHandler();
            servletContextHandler.setSecurityHandler(securityHandler);
        }
        if (securityHandler instanceof ConstraintSecurityHandler) {
            ConstraintSecurityHandler constraintSecurityHandler = (ConstraintSecurityHandler)securityHandler;
            for (String method : methods) {
                ConstraintMapping disableOptionsMapping = new ConstraintMapping();
                Constraint disableOptionsConstraint = new Constraint();
                disableOptionsConstraint.setName("Disable methods");
                disableOptionsConstraint.setAuthenticate(true);
                disableOptionsMapping.setConstraint(disableOptionsConstraint);
                disableOptionsMapping.setPathSpec("/");
                disableOptionsMapping.setMethod(method);
                constraintSecurityHandler.addConstraintMapping(disableOptionsMapping);
            }
            ConstraintMapping enableEverythingButOptionsMapping = new ConstraintMapping();
            Constraint enableEverythingButOptionsConstraint = new Constraint();
            enableEverythingButOptionsConstraint.setName("Enable everything but methods");
            enableEverythingButOptionsMapping.setConstraint(enableEverythingButOptionsConstraint);
            enableEverythingButOptionsMapping.setMethodOmissions(methods);
            enableEverythingButOptionsMapping.setPathSpec("/");
            constraintSecurityHandler.addConstraintMapping(enableEverythingButOptionsMapping);
        }
    }

    @Override
    public void start(String[] args) throws Exception {
        String webport = WebPortUtil.getWebPort(null);
        if (webport == null) {
            String value = EmbedJettyServer.getProperty("JETTY_PORT", "8080");
            WebPortUtil.setWebPort((String)value);
            webport = value;
        }
        int port = Integer.parseInt(webport);
        String contextPath = EmbedJettyServer.getProperty("JETTY_CONTEXT", "/ierp");
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        String webappPath = EmbedJettyServer.getProperty("JETTY_WEBAPP_PATH", "webapp");
        Integer maxThreads = Configs.isWebResourceBalanceEnable() ? Integer.parseInt(EmbedJettyServer.getProperty("JETTY_DISPATCH_MAXTHREADS", "50")) : Integer.parseInt(EmbedJettyServer.getProperty("JETTY_MAXTHREADS", "200"));
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads.intValue());
        MetricSystem.registerGauge((String)"kd.metrics.jettyserver.http.threadpool.maxThreads", () -> maxThreads);
        MetricSystem.registerGauge((String)"kd.metrics.jettyserver.http.threadpool.busyThreads", () -> threadPool.getBusyThreads());
        threadPool.setName("http-request-pool");
        Server server = new Server((ThreadPool)threadPool);
        HttpConfiguration httpConfig = new HttpConfiguration();
        this.setHttpConfiguration(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        connector.setPort(port);
        connector.setHost(NetAddressUtils.getBindedHostIP());
        connector.setIdleTimeout((long)Integer.getInteger("org.eclipse.jetty.http.timeout", 30000).intValue());
        server.addConnector((Connector)connector);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        server.addBean((Object)mbContainer);
        WebAppContext ierpContext = new WebAppContext();
        ierpContext.setContextPath(contextPath);
        String source = EmbedJettyServer.getProperty("JETTY_WEBXML_PATH", EmbedJettyServer.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
        if (source.indexOf("target/classes") > 0) {
            ierpContext.setDescriptor("file:" + source);
        } else {
            ierpContext.setDescriptor("jar:" + source);
        }
        String webResourcPath = EmbedJettyServer.getProperty("JETTY_WEBRES_PATH", null);
        if (webResourcPath != null) {
            ierpContext.setResourceBase(webResourcPath + "/");
        } else {
            ierpContext.setResourceBase(webappPath + "/");
        }
        ierpContext.setClassLoader(EmbedJettyServer.class.getClassLoader());
        ierpContext.setParentLoaderPriority(true);
        int max = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormContentSize", 200000000);
        ierpContext.setMaxFormContentSize(max);
        ierpContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        if (Instance.isLightWeightDeploy()) {
            ierpContext.setInitParameter("useFileMappedBuffer", "false");
            ierpContext.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        }
        server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)max);
        MonitorInstaller.install((Object)ierpContext);
        EyeInstaller.install((ServletContextHandler)ierpContext);
        MonitorInstaller.installIerp((Object)ierpContext);
        EyeInstaller.installIerp((Object)ierpContext);
        ServletContextHandler monitorContext = new ServletContextHandler();
        MonitorInstaller.install((Object)monitorContext);
        EyeInstaller.install((ServletContextHandler)monitorContext);
        MsgWebSocketHandler msgHandler = new MsgWebSocketHandler();
        ContextHandler msgWebsocketContext = new ContextHandler();
        msgWebsocketContext.setContextPath(contextPath + "/msgwatch/*");
        msgWebsocketContext.setHandler((Handler)msgHandler);
        ContextHandler msgWebsocketContext1 = new ContextHandler();
        msgWebsocketContext1.setContextPath("/msgwatch/*");
        msgWebsocketContext1.setHandler((Handler)msgHandler);
        EmbedJettyServer.disableMethods(monitorContext, new String[]{"TRACE", "OPTIONS"});
        ContextHandlerCollection handler = new ContextHandlerCollection();
        handler.addHandler((Handler)ierpContext);
        handler.addHandler((Handler)monitorContext);
        handler.addHandler((Handler)msgWebsocketContext);
        handler.addHandler((Handler)msgWebsocketContext1);
        server.setHandler((Handler)handler);
        WebSocketServerContainerInitializer.configureContext((ServletContextHandler)ierpContext);
        try {
            server.start();
            HttpGenerator.setJettyVersion((String)"UNKNOW");
        }
        catch (BindException ex) {
            logger.error((Object)"BindException,Execute System.exit(1) starting to exit the service", (Throwable)ex);
            ex.printStackTrace();
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
        }
        Throwable t = ierpContext.getUnavailableException();
        if (t != null) {
            throw new Error("WebContext start failed:" + t.getMessage(), t);
        }
        if (ierpContext.isFailed()) {
            throw new Error("WebContext start failed.");
        }
        server.join();
    }

    private void setHttpConfiguration(HttpConfiguration httpConfig) {
        Integer requestHeaderSize = Integer.getInteger("org.eclipse.jetty.request.header.size", 8192);
        httpConfig.setRequestHeaderSize(requestHeaderSize.intValue());
        Integer responseHeaderSize = Integer.getInteger("org.eclipse.jetty.response.header.size", 8192);
        httpConfig.setResponseHeaderSize(responseHeaderSize.intValue());
        Integer headerCacheSize = Integer.getInteger("org.eclipse.jetty.header.cache.size", 1024);
        httpConfig.setHeaderCacheSize(headerCacheSize.intValue());
    }
}

