/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.embedtomcat;

import java.io.IOException;
import javax.servlet.Filter;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.framework.filter.EncodingFilter;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.service.bootstrap.BootServer;
import kd.bos.service.web.WebResourceUtils;
import kd.bos.util.WebPortUtil;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanner;

public class EmbedTomcatServer
implements BootServer {
    public static final String SERVER_CONNECTION_TIMEOUT = "server.connection-timeout";
    public static final String SERVER_MAX_HTTP_HEADER_SIZE = "server.max-http-header-size";
    public static final String SERVER_AAS_MAX_THREADS = "server.tomcat.max-threads";
    private static final String ENCODING_FILTER = "encodingFilter";

    private static void initWebappDefaults(Tomcat tomcat, Context context) {
        Wrapper servlet = Tomcat.addServlet((Context)context, (String)"default", (String)"org.apache.catalina.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        context.addServletMappingDecoded("/", "default");
        context.setSessionTimeout(30);
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public void start(String[] args) {
        try {
            Valve[] valveArray;
            String webport = WebPortUtil.getWebPort(null);
            if (webport == null) {
                String value = EmbedTomcatServer.getProperty("JETTY_PORT", "8080");
                WebPortUtil.setWebPort((String)value);
                webport = value;
            }
            int port = Integer.parseInt(webport);
            String contextPath = EmbedTomcatServer.getProperty("JETTY_CONTEXT", "/ierp");
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            String webappPath = EmbedTomcatServer.getProperty("JETTY_WEBAPP_PATH", "webapp");
            Tomcat tomcat = new Tomcat();
            tomcat.getHost().setAutoDeploy(false);
            tomcat.setAddDefaultWebXmlToWebapp(false);
            ContextConfig contextConfig = new ContextConfig();
            String source = EmbedTomcatServer.getProperty("JETTY_WEBXML_PATH", EmbedTomcatServer.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
            if (source.indexOf("target/classes") > 0) {
                contextConfig.setDefaultWebXml("file:" + source);
            } else {
                contextConfig.setDefaultWebXml("jar:" + source);
            }
            Context ierpContext = tomcat.addWebapp(tomcat.getHost(), contextPath, webappPath, (LifecycleListener)contextConfig);
            StandardJarScanner scannerIerp = (StandardJarScanner)ierpContext.getJarScanner();
            scannerIerp.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

                public boolean isSkipAll() {
                    return true;
                }
            });
            ierpContext.addApplicationListener("kd.bos.msgjet.websocket.tomcat.TomcatWsContextListener");
            String containerSciFilter = "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer|org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer|com.apusic.aas.websocket.server.WsSci|com.tongweb.web.websocket.server.WsSci|com.bes.enterprise.web.websocket.server.WsSci|com.bes.enterprise.web.jasper.servlet.JasperInitializer";
            ierpContext.setContainerSciFilter(containerSciFilter);
            ierpContext.setParentClassLoader(EmbedTomcatServer.class.getClassLoader());
            this.addEncodingFilter(ierpContext);
            EmbedTomcatServer.initWebappDefaults(tomcat, ierpContext);
            this.monitorInstall(ierpContext);
            MonitorInstaller.installIerp((Object)ierpContext);
            EyeInstaller.installIerp((Object)ierpContext);
            StandardContext monitorContext = new StandardContext();
            monitorContext.setPath("");
            StandardJarScanner jarScanner = (StandardJarScanner)monitorContext.getJarScanner();
            jarScanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

                public boolean isSkipAll() {
                    return true;
                }
            });
            monitorContext.setContainerSciFilter(containerSciFilter);
            monitorContext.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
            tomcat.getHost().addChild((Container)monitorContext);
            this.monitorInstall((Context)monitorContext);
            int max = Integer.getInteger("server.tomcat.max-http-form-post-size", 200000000);
            Connector connector = new Connector();
            this.configConenctor(connector);
            connector.setPort(port);
            connector.setMaxPostSize(max);
            tomcat.setConnector(connector);
            tomcat.start();
            for (Valve tempValve : valveArray = tomcat.getHost().getPipeline().getValves()) {
                String simpleName = tempValve.getClass().getSimpleName();
                if (!simpleName.equals("ErrorReportValve")) continue;
                ErrorReportValve errorReportValve = (ErrorReportValve)tempValve;
                errorReportValve.setShowServerInfo(false);
                break;
            }
        }
        catch (Error | Exception e) {
            throw new Error("EmbedTomcatServer start exception:" + e.getMessage(), e);
        }
    }

    private void configConenctor(Connector connector) {
        AbstractProtocol protocol;
        ProtocolHandler handler = connector.getProtocolHandler();
        String _connectionTimeout = System.getProperty(SERVER_CONNECTION_TIMEOUT, System.getenv(SERVER_CONNECTION_TIMEOUT));
        String _maxHttpHeaderSize = System.getProperty(SERVER_MAX_HTTP_HEADER_SIZE, System.getenv(SERVER_MAX_HTTP_HEADER_SIZE));
        String _maxThreads = System.getProperty(SERVER_AAS_MAX_THREADS, System.getenv(SERVER_AAS_MAX_THREADS));
        if (_connectionTimeout != null && _connectionTimeout.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setConnectionTimeout(Integer.parseInt(_connectionTimeout));
        }
        if (_maxHttpHeaderSize != null && _maxHttpHeaderSize.length() > 0 && handler instanceof AbstractHttp11Protocol) {
            protocol = (AbstractHttp11Protocol)handler;
            protocol.setMaxHttpHeaderSize(Integer.parseInt(_maxHttpHeaderSize));
        }
        if (_maxThreads != null && _maxThreads.length() > 0 && handler instanceof AbstractProtocol) {
            protocol = (AbstractProtocol)handler;
            protocol.setMaxThreads(Integer.parseInt(_maxThreads));
        }
    }

    private void monitorInstall(Context context) {
        try {
            MonitorInstaller.install((Object)context);
            EyeInstaller.install((Object)context);
        }
        catch (IOException e) {
            throw new Error("EmbedTomcatServer monitorInstall IOException:" + e.getMessage(), e);
        }
    }

    private void addEncodingFilter(Context context) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(ENCODING_FILTER);
        filterDef.setFilter((Filter)new EncodingFilter());
        filterDef.setFilterClass(EncodingFilter.class.getName());
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(ENCODING_FILTER);
        filterMap.addURLPattern("*");
        context.addFilterMap(filterMap);
    }
}

