/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.bootstrap.embedtong;

import com.tongweb.container.Context;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Valve;
import com.tongweb.container.Wrapper;
import com.tongweb.container.startup.ContextConfig;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.starter.service.StandardTongWebStarer;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.descriptor.web.FilterDef;
import com.tongweb.web.util.descriptor.web.FilterMap;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import com.tongweb.web.util.scan.StandardJarScanner;
import java.io.IOException;
import javax.servlet.Filter;
import kd.bos.eye.httpserver.EyeInstaller;
import kd.bos.framework.filter.EncodingFilter;
import kd.bos.monitor.httpserver.MonitorInstaller;
import kd.bos.service.bootstrap.BootServer;
import kd.bos.service.web.WebResourceUtils;
import kd.bos.util.WebPortUtil;

public class EmbedTongServer
implements BootServer {
    public static final String TONG_WEB_TAG = "tongwebTag.";
    private static final String PORT = "server.port";
    private static final String CONTEXT_PATH = "server.context-path";
    private static final String LICENSE_TYPE = "server.tongweb.license.type";
    private static final String LICENSE_TYPE_VAL = "file";
    private static final String LICENSE_PATH = "server.tongweb.license.path";
    private static final String LICENSE_DEFAULT_CLASSPATH = "classpath:tongweb/license.dat";
    private static final String AUDIT_LOG_ENABLE = "server.tongweb.audit-log.enable";
    private static final String POST_SIZE = "server.tongweb.max-http-post-size";
    private static final String MAX_THREADS = "server.tongweb.max-threads";
    private static final String MAX_CONNECTIONS = "server.tongweb.max-connections";
    private static final String MAX_KEEP_ALIVE = "server.tongweb.max-keep-alive";
    private static final String SERVER_TONGWEB_ADDITIONAL_TLD_SKIP_PATTERNS = "server.tongweb.additional-tld-skip-patterns";
    private static final String SERVER_MAX_HTTP_FORM_POST_SIZE = "server.max-http-form-post-size";
    private static final String SERVER_MAX_THREADS = "server.max.threads";
    private static final String SERVER_MAX_CONNECTIONS = "server.max.connections";
    private static final String SERVER_MAX_KEEP_ALIVE_REQUEST = "server.max.keep_alive_request";
    public static final String ENCODING_FILTER = "encodingFilter";

    private static void initWebappDefaults(Context context) {
        Wrapper servlet = ServletContainer.addServlet((Context)context, (String)"default", (String)"com.tongweb.container.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        context.addServletMappingDecoded("/", "default");
        context.setSessionTimeout(30);
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public void start(String[] args) {
        try {
            Valve[] valveArray;
            String contextPath;
            String webport = WebPortUtil.getWebPort(null);
            if (webport == null) {
                String value = EmbedTongServer.getProperty("JETTY_PORT", "8080");
                WebPortUtil.setWebPort((String)value);
                webport = value;
            }
            if (!(contextPath = EmbedTongServer.getProperty("JETTY_CONTEXT", "/ierp")).startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            String webAppPath = EmbedTongServer.getProperty("JETTY_WEBAPP_PATH", "webapp");
            StandardTongWebStarer standardTongWebStarer = new StandardTongWebStarer();
            ServletContainer tongWeb = standardTongWebStarer.getTongweb();
            tongWeb.getHost().setAutoDeploy(false);
            tongWeb.setAddDefaultWebXmlToWebapp(false);
            System.setProperty("tongwebTag.server.port", webport);
            System.setProperty("tongwebTag.server.context-path", "");
            System.setProperty("tongwebTag.server.tongweb.license.type", LICENSE_TYPE_VAL);
            System.setProperty("tongwebTag.server.tongweb.license.path", System.getProperty(LICENSE_PATH, LICENSE_DEFAULT_CLASSPATH));
            System.setProperty("tongwebTag.server.tongweb.audit-log.enable", "false");
            int maxPostSize = Integer.getInteger(SERVER_MAX_HTTP_FORM_POST_SIZE, 200000000);
            Integer maxThreads = Integer.getInteger(SERVER_MAX_THREADS, 200);
            Integer maxConnections = Integer.getInteger(SERVER_MAX_CONNECTIONS, 10000);
            Integer maxKeepAliveRequest = Integer.getInteger(SERVER_MAX_KEEP_ALIVE_REQUEST, 100);
            System.setProperty("tongwebTag.server.tongweb.max-http-post-size", String.valueOf(maxPostSize));
            System.setProperty("tongwebTag.server.tongweb.max-threads", String.valueOf(maxThreads));
            System.setProperty("tongwebTag.server.tongweb.max-connections", String.valueOf(maxConnections));
            System.setProperty("tongwebTag.server.tongweb.max-keep-alive", String.valueOf(maxKeepAliveRequest));
            System.setProperty("tongwebTag.server.tongweb.additional-tld-skip-patterns", "*.jar");
            standardTongWebStarer.config();
            ContextConfig contextConfig = new ContextConfig();
            String source = EmbedTongServer.getProperty("JETTY_WEBXML_PATH", EmbedTongServer.class.getClassLoader().getResource(WebResourceUtils.getWebReousrceXmlPath()).getPath());
            if (source.indexOf("target/classes") > 0) {
                contextConfig.setDefaultWebXml("file:" + source);
            } else {
                contextConfig.setDefaultWebXml("jar:" + source);
            }
            Context ierpContext = tongWeb.addWebapp(tongWeb.getHost(), contextPath, webAppPath, (LifecycleListener)contextConfig);
            ierpContext.setParentClassLoader(EmbedTongServer.class.getClassLoader());
            this.addEncodingFilter(ierpContext);
            StandardJarScanner scannerIerp = (StandardJarScanner)ierpContext.getJarScanner();
            scannerIerp.setScanManifest(false);
            scannerIerp.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

                public boolean isSkipAll() {
                    return true;
                }
            });
            String containerSciFilter = "org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer|org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer|com.apusic.aas.websocket.server.WsSci|org.apache.tomcat.websocket.server.WsSci|com.bes.enterprise.web.websocket.server.WsSci|com.bes.enterprise.web.jasper.servlet.JasperInitializer";
            ierpContext.setContainerSciFilter(containerSciFilter);
            ierpContext.addApplicationListener("kd.bos.msgjet.websocket.tomcat.TomcatWsContextListener");
            EmbedTongServer.initWebappDefaults(ierpContext);
            this.monitorInstall(ierpContext);
            MonitorInstaller.installIerp((Object)ierpContext);
            EyeInstaller.installIerp((Object)ierpContext);
            Context monitorContext = (Context)tongWeb.getHost().findChild("");
            StandardJarScanner scanner = (StandardJarScanner)monitorContext.getJarScanner();
            scanner.setScanManifest(false);
            scanner.setJarScanFilter((JarScanFilter)new StandardJarScanFilter(){

                public boolean isSkipAll() {
                    return true;
                }
            });
            monitorContext.setContainerSciFilter(containerSciFilter);
            this.addEncodingFilter(monitorContext);
            this.monitorInstall(monitorContext);
            standardTongWebStarer.start();
            for (Valve tempValve : valveArray = standardTongWebStarer.getTongweb().getHost().getPipeline().getValves()) {
                String simpleName = tempValve.getClass().getSimpleName();
                if (!simpleName.equals("ErrorReportValve")) continue;
                ErrorReportValve errorReportValve = (ErrorReportValve)tempValve;
                errorReportValve.setShowServerInfo(false);
                break;
            }
        }
        catch (Error | Exception e) {
            throw new Error("EmbedTongServer start exception:" + e.getMessage(), e);
        }
    }

    private void monitorInstall(Context context) {
        try {
            MonitorInstaller.install((Object)context);
            EyeInstaller.install((Object)context);
        }
        catch (IOException e) {
            throw new Error("EmbedTongServer monitorInstall IOException:" + e.getMessage(), e);
        }
    }

    private void addEncodingFilter(Context context) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(ENCODING_FILTER);
        filterDef.setFilter((Filter)new EncodingFilter());
        filterDef.setFilterClass(EncodingFilter.class.getName());
        context.addFilterDef(filterDef);
        FilterMap filterMap = new FilterMap();
        filterMap.setFilterName(ENCODING_FILTER);
        filterMap.addURLPattern("*");
        context.addFilterMap(filterMap);
    }
}

