/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.mcserverhandler;

import kd.bos.config.client.util.ConfigUtils;
import kd.bos.service.mcserverhandler.ZKUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.SystemProperties;
import kd.bos.util.resource.Resources;
import kd.bos.zk.ZKFactory;

public class MCServerHandler {
    public static void handleMCLogin() throws Exception {
        String isMCString = SystemProperties.getWithEnv((String)"isMC");
        if ("true".equalsIgnoreCase(isMCString)) {
            String domainUrl;
            String tenant = "mc-test";
            String clusterName = SystemProperties.getWithEnv((String)"clusterName");
            if (StringUtils.isEmpty((String)clusterName)) {
                throw new Exception(Resources.getString((String)"\u6ca1\u6709\u914d\u7f6eclusterName,\u542f\u52a8\u7ec8\u6b62", (String)"MCServerHandle_0", (String)"bos-service-core", (Object[])new Object[0]));
            }
            tenant = SystemProperties.getWithEnv((String)"domain.tenantCode", (String)clusterName);
            String zkUrl = null;
            if (StringUtils.isNotEmpty((String)SystemProperties.getWithEnv((String)"configUrl"))) {
                zkUrl = SystemProperties.getWithEnv((String)"configUrl");
                System.setProperty("configUrl", zkUrl);
            }
            if (StringUtils.isNotEmpty((String)(domainUrl = System.getenv("domain_contextUrl")))) {
                System.setProperty("domain.contextUrl", domainUrl);
            }
            System.setProperty("mc.is.mcserver", "true");
            System.setProperty("domain.tenantCode", tenant);
            System.setProperty("mc.tenant.code", tenant);
            System.setProperty("tenant.code.type", "config");
            MCServerHandler.setPropertyIfEmpty("clusterName", clusterName);
            System.setProperty("mc.type", "ZK");
            System.setProperty("login.type", "YUNZHIJIA");
            String configPath = ConfigUtils.getCommonPropertyPath((String)clusterName);
            ZKUtils.setZkData(zkUrl, configPath + "/SystemPropertiesNotShow", "mcdburl_ksql,mcdbdriver_ksql,");
            ZKUtils.setZkData(zkUrl, configPath + "/log.config", "  <root level=\"INFO\"></root>");
            String allTeant = String.format("[{\"tenantnumber\":\"%s\",\"tenantid\":\"15321599999999999\",\"tenantname\":\"MC_TENANT\"}]", tenant);
            ZKUtils.setZkData(zkUrl, configPath + "/mc.tenant.ids", allTeant);
            String propPath = ConfigUtils.getAppPropertyPath((String)clusterName, (String)"mservice");
            ZKUtils.setZkData(zkUrl, propPath + "/datasource.properties", "maxIdle=2\ndatasource.type=dbcp\nmaxTotal=123");
            String servicePath = ConfigUtils.getAppServicePath((String)clusterName, (String)"mservice");
            ZKUtils.setZkData(zkUrl, servicePath + "/dispatch.service", "interface=kd.bos.service.DispatchService\nclass=kd.bos.service.DispatchServiceImpl");
            ZKUtils.setZkData(zkUrl, servicePath + "/DispatchService.consumer", "interface=kd.bos.service.DispatchService");
            String webPath = ConfigUtils.getAppServicePath((String)clusterName, (String)"web");
            ZKUtils.setZkData(zkUrl, webPath + "/DispatchService.consumer", "interface=kd.bos.service.DispatchService");
            propPath = ConfigUtils.getAppPropertyPath((String)clusterName, (String)"web");
            ZKUtils.setZkData(zkUrl, propPath + "/actionfiles.config", "/kd.eas.file.a.xml\nkd.eas.b.xml\nc.xml\nd.eas.file.xml");
            String dbKey = String.format("mc.tenant.%s.data", tenant);
            String dbZKKey = MCServerHandler.getCommonPropPathByCluster(clusterName) + dbKey;
            String dbContent = null;
            try {
                String tenantConfigKey = MCServerHandler.getCommonPropPathByCluster(clusterName) + "tenant.code.type";
                ZKUtils.setZkData(zkUrl, tenantConfigKey, "config");
                String tenantKey = MCServerHandler.getCommonPropPathByCluster(clusterName) + "mc.tenant.code";
                ZKUtils.setZkData(zkUrl, tenantKey, tenant);
                dbContent = ZKUtils.getZkData(zkUrl, dbZKKey);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
            if (StringUtils.isEmpty(dbContent)) {
                System.setProperty(String.format("mc.tenant.%s.data", tenant), "");
            }
        }
    }

    private static String getCommonPropPathByCluster(String clusterName) {
        return MCServerHandler.initRootPath() + clusterName + "/config/common/prop/";
    }

    private static String initRootPath() {
        String configUrl = SystemProperties.getWithEnv((String)"configUrl");
        return ZKFactory.getZkRootPath((String)configUrl);
    }

    private static void setPropertyIfEmpty(String key, String value) {
        if (SystemProperties.getWithEnv((String)key) == null) {
            System.setProperty(key, value);
        }
    }
}

