/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.mcserverhandler;

import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;

public class ZKUtils {
    public static void setZkData(String zkUrl, String key, String value) throws Exception {
        if (StringUtils.isEmpty((String)zkUrl) || StringUtils.isEmpty((String)key)) {
            throw new KDException(new ErrorCode("error", Resources.getString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a.", (String)"ZKUtils_0", (String)"bos-service-core", (Object[])new Object[0])), new Object[0]);
        }
        CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
        if (zkClient.checkExists().forPath(key) == null) {
            ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value == null ? null : value.getBytes());
        } else {
            zkClient.setData().forPath(key, value == null ? null : value.getBytes());
        }
    }

    public static String getZkData(String zkUrl, String key) throws Exception {
        if (StringUtils.isEmpty((String)zkUrl) || StringUtils.isEmpty((String)key)) {
            throw new KDException(new ErrorCode("error", Resources.getString((String)"zkUrl\u548ckey\u4e0d\u5141\u8bb8\u4e3a\u7a7a.", (String)"ZKUtils_0", (String)"bos-service-core", (Object[])new Object[0])), new Object[0]);
        }
        CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
        byte[] bytes = (byte[])zkClient.getData().forPath(key);
        return new String(bytes);
    }
}

