/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.web.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import kd.bos.service.invoke.MServiceFactory;
import kd.bos.service.web.filter.KFilter;
import kd.bos.service.web.filter.KFilterConfig;
import kd.bos.service.web.filter.KFilterHandler;
import kd.bos.service.web.servlet.KServlet;
import kd.bos.service.web.servlet.KServletConfig;
import kd.bos.service.web.servlet.KServletHandler;
import kd.bos.thread.OutOfMemoryObserver;
import kd.bos.thread.ThreadTruck;

public class KDCommonFilter
implements Filter {
    private static List<KFilterHandler> filterList = KFilterConfig.getKFilters();
    public static final String ISMSERVICEREQUSET = "isMserviceRequset";
    public static final String REQUEST_URI = "request_uri";
    private static List<KServletHandler> servletList = KServletConfig.getKServlets();
    private static String servletChainPre = System.getProperty("kdservlet.chain.pre", Boolean.getBoolean("springboot.enable") ? "dispatcherServlet@" : "ChainEnd@");

    private static FilterChain build(String uri, FilterChain paramFilterChain) {
        if (servletList.size() > 0 && paramFilterChain.toString().startsWith(servletChainPre)) {
            int servletSize = servletList.size();
            for (int i = 0; i < servletSize; ++i) {
                final KServletHandler kservlet = servletList.get(i);
                if (!kservlet.isMatch(uri)) continue;
                paramFilterChain = new FilterChain(){

                    public void doFilter(ServletRequest paramServletRequest, ServletResponse paramServletResponse) throws IOException, ServletException {
                        KServlet servlet = kservlet.getServlet();
                        servlet.service(paramServletRequest, paramServletResponse);
                    }
                };
                break;
            }
        }
        FilterChain last = paramFilterChain;
        boolean isMserviceRequset = KDCommonFilter.isMserviceRequest(uri);
        if (isMserviceRequset) {
            ThreadTruck.put((Object)ISMSERVICEREQUSET, (Object)Boolean.TRUE.toString());
        }
        for (int i = filterList.size() - 1; i >= 0; --i) {
            KFilterHandler kfilter = filterList.get(i);
            if (!kfilter.isMatch(uri) && (!isMserviceRequset || !"providerInterceptorEntranceFilter".equals(kfilter.getName()))) continue;
            final KFilter filter = kfilter.getFilter();
            final FilterChain next = last;
            last = new FilterChain(){

                public void doFilter(ServletRequest paramServletRequest, ServletResponse paramServletResponse) throws IOException, ServletException {
                    filter.doFilter(paramServletRequest, paramServletResponse, next);
                }
            };
        }
        return last;
    }

    private static boolean isMserviceRequest(String uri) {
        if (uri.endsWith(".do")) {
            return false;
        }
        if ("/health/handShake".equals(uri)) {
            return true;
        }
        String uriNoPre = uri;
        if (uriNoPre.startsWith("/")) {
            uriNoPre = uri.substring(1);
        }
        if ("kdDispatchServiceFeign".equals(uriNoPre) || "kdConverterServiceRequest".equals(uriNoPre)) {
            return true;
        }
        return MServiceFactory.getServiceDefineByPath((String)uri) != null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest paramServletRequest, ServletResponse paramServletResponse, FilterChain paramFilterChain) throws IOException, ServletException {
        String uri = this.getURI(paramServletRequest);
        try {
            ThreadTruck.put((Object)REQUEST_URI, (Object)uri);
            FilterChain chain = KDCommonFilter.build(uri, paramFilterChain);
            chain.doFilter(paramServletRequest, paramServletResponse);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryObserver.onOutOfMemory((OutOfMemoryError)e);
            throw e;
        }
        finally {
            ThreadTruck.remove((Object)ISMSERVICEREQUSET);
            ThreadTruck.remove((Object)REQUEST_URI);
        }
    }

    private String getURI(ServletRequest paramServletRequest) {
        String uri = ((HttpServletRequest)paramServletRequest).getRequestURI();
        String contextPath = ((HttpServletRequest)paramServletRequest).getContextPath();
        uri = uri.split("\\?")[0];
        return uri.substring(contextPath.length(), uri.length());
    }
}

