/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.web.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.env.Env;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.service.web.filter.FilterProviderSPI;
import kd.bos.service.web.filter.KFilter;
import kd.bos.service.web.filter.KFilterHandler;
import kd.bos.service.web.filter.KFilterParam;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.FileUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KFilterConfig {
    private static Logger logger = Logger.getLogger(KFilterConfig.class);
    private static List<KFilterHandler> filters = new ArrayList<KFilterHandler>();
    private static Map<String, KFilterHandler> filterHandleMap = new HashMap<String, KFilterHandler>(8);
    private static Map<String, String> urlPatternMappingMap = new HashMap<String, String>(8);

    private static void staticLoad() {
        String urlPatternMappingConfig = ConfigurationUtil.getString((String)"kfilter.urlPatternMapping.config");
        if (urlPatternMappingConfig != null) {
            Properties p = new Properties();
            try {
                p.load(new StringReader(urlPatternMappingConfig));
                for (String key : p.stringPropertyNames()) {
                    urlPatternMappingMap.put(key, p.getProperty(key));
                }
            }
            catch (IOException e) {
                logger.error((Object)("load urlPatternMapping error," + urlPatternMappingConfig), (Throwable)e);
            }
        }
        try {
            KFilterConfig.load();
            Collections.sort(filters, new Comparator<KFilterHandler>(){

                @Override
                public int compare(KFilterHandler o, KFilterHandler o1) {
                    return o.getOrder() - o1.getOrder();
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load configuration", (Throwable)e);
        }
    }

    private static void load() {
        InputStream inputStream = null;
        try {
            inputStream = Env.isMicroKernel() ? KFilterConfig.class.getResourceAsStream("/microKernel/kfilter.xml") : KFilterConfig.class.getResourceAsStream("/webapp/kfilter.xml");
            KFilterConfig.load(inputStream);
        }
        catch (Error | Exception t) {
            logger.error((Object)"can't found actionconfig.xml");
            throw new KDException(BosErrorCode.configNotFound, new Object[]{"can't found actionconfig.xml"});
        }
        try {
            KFilterConfig.loadFromSPI();
        }
        catch (Error | Exception e) {
            logger.error((Object)"Can't not load loadFromSPI", e);
        }
        try {
            KFilterConfig.loadConfiggedActionFiles();
        }
        catch (Error | Exception e) {
            logger.error((Object)"Can't not load loadConfiggedActions", e);
        }
    }

    private static void loadFromSPI() {
        ExtensionFactory extensionFactory;
        FilterProviderSPI filterProviderSPI;
        String spiFilterType = System.getProperty("spiFilter.type");
        if (spiFilterType != null && spiFilterType.trim().length() > 0 && (filterProviderSPI = (FilterProviderSPI)(extensionFactory = ExtensionFactory.getExtensionFacotry(FilterProviderSPI.class)).getExtension(spiFilterType)).isEnable()) {
            KFilterConfig.load(filterProviderSPI.getFilterFileInputStream());
        }
    }

    private static void loadConfiggedActionFiles() throws Exception {
        String configFiles = System.getProperty("KFilterConfigFiles.config");
        if (configFiles != null && configFiles.trim().length() > 0) {
            String lineStr;
            ByteArrayInputStream is = new ByteArrayInputStream(configFiles.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((lineStr = br.readLine()) != null) {
                if (lineStr.trim().endsWith(".xml")) {
                    if ((lineStr = lineStr.substring(0, lineStr.length() - 4).replaceAll("\\.", "/") + ".xml").startsWith("/")) {
                        lineStr = lineStr.substring(1);
                    }
                    KFilterConfig.parseInclude(lineStr);
                    continue;
                }
                logger.error((Object)("config error actionfile:" + lineStr));
            }
        }
    }

    private static void parseInclude(String file) {
        InputStream stream = null;
        try {
            stream = KFilterConfig.class.getResourceAsStream("/" + file);
            if (stream == null) {
                stream = new FileInputStream(FileUtils.checkFileUrl((String)file));
            }
        }
        catch (Exception t) {
            logger.warn((Object)("can't found " + file));
            return;
        }
        if (stream != null) {
            KFilterConfig.load(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(InputStream inputStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = null;
            doc = builder.parse(inputStream);
            Element root = (Element)doc.getElementsByTagName("web-app").item(0);
            NodeList nodeList = root.getElementsByTagName("filter");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element ele = (Element)nodeList.item(i);
                KFilterConfig.parseFilter(ele);
            }
        }
        catch (Error | Exception t) {
            logger.error((Object)t.getMessage(), t);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Error | Exception throwable) {}
        }
    }

    private static void parseFilter(Element ele) {
        final String filterNameStr = KFilterConfig.getSingleElementValue(ele, "filter-name");
        String filterClassStr = KFilterConfig.getSingleElementValue(ele, "filter-class");
        int order = KFilterConfig.getOrder(KFilterConfig.getSingleElementValue(ele, "filter-order"));
        List<String> urlPattern = KFilterConfig.getFilterUrlPattern(ele, filterNameStr);
        NodeList nodeList = ele.getElementsByTagName("init-param");
        final Hashtable<String, String> paramsTable = new Hashtable<String, String>(1);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childItemElement = (Element)nodeList.item(i);
            NodeList paramNodeList = childItemElement.getElementsByTagName("param");
            for (int j = 0; j < paramNodeList.getLength(); ++j) {
                childItemElement = (Element)paramNodeList.item(j);
                String nameStr = childItemElement.getAttribute("paramname");
                String valueStr = childItemElement.getAttribute("paramvalue");
                paramsTable.put(nameStr, valueStr);
            }
        }
        try {
            KFilter kfilter;
            Object obj = KFilterConfig.createByClass(filterClassStr);
            KFilterHandler kfilterHandler = new KFilterHandler();
            kfilterHandler.setOrder(order);
            if (obj instanceof Filter) {
                final Filter filter = (Filter)obj;
                kfilter = new KFilter(){

                    @Override
                    public void init(final KFilterParam param) throws ServletException {
                        filter.init(new FilterConfig(){

                            public String getFilterName() {
                                return param.getFilterName();
                            }

                            public ServletContext getServletContext() {
                                return null;
                            }

                            public String getInitParameter(String paramString) {
                                return param.getInitParameter(paramString);
                            }

                            public Enumeration<String> getInitParameterNames() {
                                return param.getInitParameterNames();
                            }
                        });
                    }

                    @Override
                    public void doFilter(ServletRequest paramServletRequest, ServletResponse paramServletResponse, FilterChain paramFilterChain) throws IOException, ServletException {
                        filter.doFilter(paramServletRequest, paramServletResponse, paramFilterChain);
                    }
                };
            } else if (obj instanceof KFilter) {
                kfilter = (KFilter)obj;
            } else {
                throw new KDException(BosErrorCode.systemError, new Object[]{"unsupport filter type :" + obj.getClass().getName()});
            }
            kfilter.init(new KFilterParam(){

                @Override
                public String getFilterName() {
                    return filterNameStr;
                }

                @Override
                public String getInitParameter(String paramString) {
                    return (String)paramsTable.get(paramString);
                }

                @Override
                public Enumeration<String> getInitParameterNames() {
                    return paramsTable.keys();
                }
            });
            kfilterHandler.setFilter(kfilter);
            kfilterHandler.setName(filterNameStr);
            kfilterHandler.setUrlPartten(urlPattern);
            if (!filterHandleMap.containsKey(filterNameStr)) {
                filters.add(kfilterHandler);
                filterHandleMap.put(filterNameStr, kfilterHandler);
            } else {
                logger.error((Object)("cannt create filter beacause exists filter  " + filterNameStr));
            }
        }
        catch (Error | Exception e) {
            logger.error((Object)("Can't create Filter by " + filterClassStr), e);
        }
    }

    private static int getOrder(String val) {
        if (val == null) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(val);
    }

    private static List<String> getFilterUrlPattern(Element ele, String filterName) {
        String configgedUrlPatternStr = System.getProperty("kfilter." + filterName + ".filter-mapping");
        if (configgedUrlPatternStr != null) {
            return Arrays.asList(configgedUrlPatternStr.split(","));
        }
        List<String> urlPatternList = KFilterConfig.getListElementValue(ele, "filter-mapping", "url-pattern");
        if (!urlPatternMappingMap.isEmpty()) {
            for (int i = 0; i < urlPatternList.size(); ++i) {
                String pattern = urlPatternMappingMap.get(urlPatternList.get(i));
                if (pattern == null) continue;
                urlPatternList.set(i, pattern);
            }
        }
        return urlPatternList;
    }

    private static Object createByClass(String classNameStr) {
        try {
            return Class.forName(classNameStr).newInstance();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.cannotLoadBeanClass, "Can't create Filter by " + classNameStr, (Throwable)e);
        }
    }

    private static String getSingleElementValue(Element element, String nameStr) {
        NodeList nodes = element.getElementsByTagName(nameStr);
        if (nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0).getFirstChild().getNodeValue();
    }

    private static List<String> getListElementValue(Element element, String nameStr, String childValue) {
        NodeList nodes = element.getElementsByTagName(nameStr);
        NodeList childList = ((Element)nodes.item(0)).getElementsByTagName(childValue);
        ArrayList<String> list = new ArrayList<String>(8);
        for (int i = 0; i < childList.getLength(); ++i) {
            Element childItem = (Element)childList.item(i);
            String urlParten = childItem.getFirstChild().getNodeValue();
            list.add(urlParten);
        }
        return list;
    }

    public static List<KFilterHandler> getKFilters() {
        return Collections.unmodifiableList(filters);
    }

    static {
        KFilterConfig.staticLoad();
    }
}

