/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.web.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.web.servlet.KServlet;
import kd.bos.service.web.servlet.KServletHandler;
import kd.bos.service.web.servlet.KServletParam;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.FileUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KServletConfig {
    private static Logger logger = Logger.getLogger(KServletConfig.class);
    private static List<KServletHandler> servlets = new ArrayList<KServletHandler>();
    private static Map<String, KServletHandler> servletMap = new HashMap<String, KServletHandler>(8);
    private static Map<String, String> urlPatternMapping = new HashMap<String, String>(8);

    private static void staticLoad() {
        String urlPatternMappingConf = ConfigurationUtil.getString((String)"kservlet.urlPatternMapping.config");
        if (urlPatternMappingConf != null) {
            Properties p = new Properties();
            try {
                p.load(new StringReader(urlPatternMappingConf));
                for (String key : p.stringPropertyNames()) {
                    urlPatternMapping.put(key, p.getProperty(key));
                }
            }
            catch (IOException e) {
                logger.error((Object)"load urlPatternMapping error", (Throwable)e);
            }
        }
        try {
            KServletConfig.load();
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load configuration", (Throwable)e);
        }
    }

    private static void load() {
        try {
            KServletConfig.loadConfiggedActionFiles();
        }
        catch (Exception e) {
            logger.error((Object)"Can't not load loadConfiggedActions", (Throwable)e);
        }
    }

    private static void loadConfiggedActionFiles() throws Exception {
        String configActionFiles = System.getProperty("KServletConfigFiles.config");
        if (configActionFiles != null && configActionFiles.trim().length() > 0) {
            String line;
            ByteArrayInputStream is = new ByteArrayInputStream(configActionFiles.getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.trim().endsWith(".xml")) {
                    if ((line = line.substring(0, line.length() - 4).replaceAll("\\.", "/") + ".xml").startsWith("/")) {
                        line = line.substring(1);
                    }
                    KServletConfig.parseInclude(line);
                    continue;
                }
                logger.error((Object)("config error actionfile:" + line));
            }
        }
    }

    private static void parseInclude(String file) {
        InputStream in = null;
        try {
            in = KServletConfig.class.getResourceAsStream("/" + file);
            if (in == null) {
                in = new FileInputStream(FileUtils.checkFileUrl((String)file));
            }
        }
        catch (Exception t) {
            logger.warn((Object)("can't found " + file));
            return;
        }
        if (in != null) {
            KServletConfig.load(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(InputStream in) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Element root = (Element)document.getElementsByTagName("web-app").item(0);
            NodeList list = root.getElementsByTagName("servlet");
            for (int i = 0; i < list.getLength(); ++i) {
                Element ele = (Element)list.item(i);
                KServletConfig.parseServlet(ele);
            }
        }
        catch (Exception t) {
            logger.error((Object)t.getMessage(), (Throwable)t);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void parseServlet(Element ele) {
        final String servletName = KServletConfig.getSingleElementValue(ele, "servlet-name");
        String servletClass = KServletConfig.getSingleElementValue(ele, "servlet-class");
        List<String> urlPattern = KServletConfig.getServletUrlPattern(ele, servletName);
        NodeList nodeList = ele.getElementsByTagName("init-param");
        final Hashtable<String, String> params = new Hashtable<String, String>(1);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childItem = (Element)nodeList.item(i);
            NodeList paramNodeList = childItem.getElementsByTagName("param");
            for (int j = 0; j < paramNodeList.getLength(); ++j) {
                childItem = (Element)paramNodeList.item(j);
                String name = childItem.getAttribute("paramname");
                String value = childItem.getAttribute("paramvalue");
                params.put(name, value);
            }
        }
        try {
            KServlet kservlet;
            Object o = KServletConfig.createByClass(servletClass);
            KServletHandler kservletHandler = new KServletHandler();
            if (o instanceof Servlet) {
                final Servlet f = (Servlet)o;
                kservlet = new KServlet(){

                    @Override
                    public void init(final KServletParam param) throws ServletException {
                        f.init(new ServletConfig(){

                            public String getServletName() {
                                return param.getServletName();
                            }

                            public ServletContext getServletContext() {
                                return null;
                            }

                            public String getInitParameter(String paramString) {
                                return param.getInitParameter(paramString);
                            }

                            public Enumeration<String> getInitParameterNames() {
                                return param.getInitParameterNames();
                            }
                        });
                    }

                    @Override
                    public void service(ServletRequest paramServletRequest, ServletResponse paramServletResponse) throws ServletException, IOException {
                        f.service(paramServletRequest, paramServletResponse);
                    }
                };
            } else if (o instanceof KServlet) {
                kservlet = (KServlet)o;
            } else {
                throw new KDException(BosErrorCode.systemError, new Object[]{"unsupport servlet type :" + o.getClass().getName()});
            }
            kservlet.init(new KServletParam(){

                @Override
                public String getServletName() {
                    return servletName;
                }

                @Override
                public String getInitParameter(String paramString) {
                    return (String)params.get(paramString);
                }

                @Override
                public Enumeration<String> getInitParameterNames() {
                    return params.keys();
                }
            });
            kservletHandler.setServlet(kservlet);
            kservletHandler.setName(servletName);
            kservletHandler.setUrlPartten(urlPattern);
            if (!servletMap.containsKey(servletName)) {
                servlets.add(kservletHandler);
                servletMap.put(servletName, kservletHandler);
            } else {
                logger.error((Object)("cannt create servlet beacause exists servlet  " + servletName));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Can't create servlet by " + servletClass), (Throwable)e);
        }
    }

    private static List<String> getServletUrlPattern(Element ele, String servletName) {
        String configgedUrlPatternStr = System.getProperty("kservlet." + servletName + ".servlet-mapping");
        if (configgedUrlPatternStr != null) {
            return Arrays.asList(configgedUrlPatternStr.split(","));
        }
        List<String> urlPattern = KServletConfig.getListElementValue(ele, "servlet-mapping", "url-pattern");
        if (!urlPatternMapping.isEmpty()) {
            for (int i = 0; i < urlPattern.size(); ++i) {
                String pattern = urlPatternMapping.get(urlPattern.get(i));
                if (pattern == null) continue;
                urlPattern.set(i, pattern);
            }
        }
        return urlPattern;
    }

    private static Object createByClass(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new KDException(BosErrorCode.cannotLoadBeanClass, new Object[]{"Can't create servlet by " + className});
        }
    }

    private static String getSingleElementValue(Element ele, String name) {
        NodeList nodeList = ele.getElementsByTagName(name);
        return nodeList.item(0).getFirstChild().getNodeValue();
    }

    private static List<String> getListElementValue(Element ele, String name, String child) {
        NodeList nodeList = ele.getElementsByTagName(name);
        NodeList childList = ((Element)nodeList.item(0)).getElementsByTagName(child);
        ArrayList<String> ls = new ArrayList<String>(8);
        for (int i = 0; i < childList.getLength(); ++i) {
            Element childItem = (Element)childList.item(i);
            String urlParten = childItem.getFirstChild().getNodeValue();
            ls.add(urlParten);
        }
        return ls;
    }

    public static List<KServletHandler> getKServlets() {
        return Collections.unmodifiableList(servlets);
    }

    static {
        KServletConfig.staticLoad();
    }
}

