/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serverless.config.ServerlessJobDef;
import kd.bos.util.StringUtils;

@XmlRootElement(name="root")
public class ServerlessJobDefConfig {
    private List<ServerlessJobDef> items;
    private static Log log = LogFactory.getLog(ServerlessJobDefConfig.class);

    @XmlElements(value={@XmlElement(name="serverlessjob", type=ServerlessJobDef.class)})
    public List<ServerlessJobDef> getItems() {
        return this.items;
    }

    public void setItems(List<ServerlessJobDef> items) {
        this.items = items;
    }

    protected static ServerlessJobDefConfig get() {
        String xml = System.getProperty("ServerlessJobDefConfig");
        ServerlessJobDefConfig configured = null;
        if (xml != null) {
            configured = ServerlessJobDefConfig.parse(xml);
        }
        ServerlessJobDefConfig base = null;
        try (InputStream in = ServerlessJobDefConfig.class.getResourceAsStream("/serverlessJobDef.xml");){
            xml = StringUtils.fromInputStream((InputStream)in, (String)"UTF-8");
            base = ServerlessJobDefConfig.parse(xml);
        }
        catch (IOException e) {
            log.error("Can't load serverlessJobDef.xml", (Throwable)e);
        }
        return ServerlessJobDefConfig.mergeConfig(configured, base);
    }

    private static ServerlessJobDefConfig mergeConfig(ServerlessJobDefConfig left, ServerlessJobDefConfig right) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        List<ServerlessJobDef> leftJobDefs = left.getItems();
        List<ServerlessJobDef> rightJobDefs = right.getItems();
        for (ServerlessJobDef leftService : leftJobDefs) {
            String jobName = leftService.getJobname();
            Iterator<ServerlessJobDef> iterator = rightJobDefs.iterator();
            while (iterator.hasNext()) {
                ServerlessJobDef rightService = iterator.next();
                if (!jobName.equalsIgnoreCase(rightService.getJobname())) continue;
                iterator.remove();
            }
        }
        leftJobDefs.addAll(rightJobDefs);
        left.setItems(leftJobDefs);
        return left;
    }

    private static ServerlessJobDefConfig parse(String xml) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServerlessJobDefConfig.class});
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", true);
            XMLStreamReader reader = xif.createXMLStreamReader(new StringReader(xml));
            Unmarshaller un = jaxbContext.createUnmarshaller();
            ServerlessJobDefConfig usageConfig = (ServerlessJobDefConfig)un.unmarshal(reader);
            return usageConfig;
        }
        catch (JAXBException | XMLStreamException e) {
            log.error(e);
            return null;
        }
    }
}

