/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.container;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.serverless.config.ServerlessJobDef;
import kd.bos.util.StringUtils;

public class EnvVariable {
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final String DEFAULT_ENV_VARIABLE_KEYS = "JAVA_HOME,appName,WEB_PORT,BIZLIBS,APPSTORE_URL,BOSLIBS,appSplit,JVM_OPTS,clusterName,configUrl,ENABLE_JETTY,webmserviceinone,configAppName,TRDLIBS";

    public static Map<String, String> getStartEnvVariables(ServerlessJobDef jobDef) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        String envVariableKeys = System.getProperty("serverless.env.start.keys", DEFAULT_ENV_VARIABLE_KEYS);
        for (String key : envVariableKeys.split(",")) {
            map.put(key, System.getProperty(key));
        }
        map.put("serverless.service.enable", TRUE_STR);
        map.put("mq.consumer.register", FALSE_STR);
        map.put("dubbo.registry.register", FALSE_STR);
        map.put("appSplit", FALSE_STR);
        String bizLibs = System.getProperty("SERVERLESS_LIBS", System.getProperty("BIZLIBS"));
        map.put("BIZLIBS", bizLibs);
        int xmsMemory = jobDef.getMemoryMB();
        int realMemory = (int)((double)(xmsMemory + 256) * 1.3);
        jobDef.setMemoryMB(realMemory);
        String jvmOptsTemp = System.getProperty("JVM_OPTS", "-server -Xms3000m -Xmx3000m -XX:MetaspaceSize=256m");
        StringBuilder jvmOptsSb = new StringBuilder();
        String xmsStr = "-Xms" + xmsMemory + "m";
        String xmxStr = "-Xmx" + xmsMemory + "m";
        for (String str : jvmOptsTemp.split(" ")) {
            if (str.startsWith("-Xms")) {
                jvmOptsSb.append(xmsStr);
            } else if (str.startsWith("-Xmx")) {
                jvmOptsSb.append(xmxStr);
            } else {
                jvmOptsSb.append(str);
            }
            jvmOptsSb.append(" ");
        }
        map.put("JVM_OPTS", jvmOptsSb.substring(0, jvmOptsSb.length() - 1));
        return map;
    }

    public static Map<String, String> getAWSConfigMap() {
        String value = System.getProperty("serverless.aws.config");
        if (StringUtils.isEmpty((String)value)) {
            throw new KDException(BosErrorCode.serverlessException, new Object[]{"serverless.aws.config is not config."});
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.serverlessException, new Object[0]);
        }
        for (String key : "imageUrl,arn".split(",")) {
            String keyStr = prop.getProperty(key);
            if (StringUtils.isEmpty((String)keyStr)) {
                throw new KDException(BosErrorCode.serverlessException, new Object[]{key + " can't be empty."});
            }
            result.put(key, keyStr.trim());
        }
        return result;
    }

    public static Map<String, String> getHWConfigMap() {
        String value = System.getProperty("serverless.hw.config");
        if (StringUtils.isEmpty((String)value)) {
            throw new KDException(BosErrorCode.serverlessException, new Object[]{"serverless.hw.config is not config."});
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.serverlessException, new Object[]{e});
        }
        for (String key : "accessKeyId,secretAccessKey,imageUrl,cciEndpoint,cciNameSpace".split(",")) {
            String keyStr = prop.getProperty(key);
            if (StringUtils.isEmpty((String)keyStr)) {
                throw new KDException(BosErrorCode.serverlessException, new Object[]{key + " can't be empty."});
            }
            result.put(key, keyStr.trim());
        }
        return result;
    }
}

