/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.core;

import java.io.Serializable;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serverless.api.JobRequest;
import kd.bos.serverless.api.JobStatus;
import kd.bos.serverless.api.JobSubmitter;
import kd.bos.serverless.api.StatusEnum;
import kd.bos.serverless.config.Configuration;
import kd.bos.serverless.config.ServerlessJobDef;
import kd.bos.serverless.core.JobStatusCache;
import kd.bos.serverless.core.MessageSidecar;
import kd.bos.serverless.core.MessageTruckFactory;
import kd.bos.serverless.core.ServerlessJobManagerFactory;
import kd.bos.util.ConfigurationUtil;

public class DefaultJobSubmiter
implements JobSubmitter {
    private final Log log = LogFactory.getLog(DefaultJobSubmiter.class);
    private static int waitInterval = ConfigurationUtil.getInteger((String)"serverless.job.await.interval", (Integer)1000);

    public void submit(JobRequest jobtask, int timeoutSecond) {
        this.innerSubmit(jobtask, RequestContext.get(), timeoutSecond);
    }

    public JobStatus getJobStatus(JobRequest jobRequest) {
        return this.getJobStatus(jobRequest.getJobid());
    }

    public JobStatus getJobStatus(String jobId) {
        return JobStatusCache.getStatus(jobId);
    }

    private void innerSubmit(JobRequest jobtask, RequestContext rc, int timeoutSecond) {
        String jobId = jobtask.getJobid();
        MessageTruckFactory.get().storeParameter("_sys." + jobId, (Serializable)this.wrapperParams(jobtask.getJobName(), jobtask.getParam(), rc));
        ServerlessJobDef jobDef = Configuration.getJob(jobtask.getJobName());
        ServerlessJobManagerFactory.getManager().submit(jobDef, jobId);
        long endTime = (long)(timeoutSecond * 1000) + System.currentTimeMillis();
        do {
            JobStatus jobStatus;
            if ((jobStatus = JobStatusCache.getStatus(jobId)) != null) {
                StatusEnum status = jobStatus.getStatusEnum();
                if (status == StatusEnum.FINISH) {
                    return;
                }
                if (status == StatusEnum.ERROR) {
                    throw new KDException(BosErrorCode.serverlessException, new Object[]{"Job excute error:" + jobId + " des:" + jobStatus.getDes()});
                }
            }
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException e) {
                this.log.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        } while (System.currentTimeMillis() < endTime);
        throw new KDException(BosErrorCode.serverlessException, new Object[]{"Timeout when execute Job " + jobId});
    }

    private MessageSidecar wrapperParams(String jobname, Serializable message, RequestContext rc) {
        MessageSidecar messageCar = new MessageSidecar(jobname);
        messageCar.setMessage(message);
        messageCar.setRc(rc);
        return messageCar;
    }
}

