/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.core;

import kd.bos.serverless.api.ServerlessException;
import kd.bos.serverless.core.ServerlessJobManager;
import kd.bos.serverless.core.manager.aws.ServerlessAWSJobManager;
import kd.bos.serverless.core.manager.hw.ServerlessHWJobManager;
import kd.bos.serverless.core.manager.local.ServerlessLocalJobManager;
import kd.bos.serverless.core.manager.mservice.ServerlessMServiceJobManager;

public class ServerlessJobManagerFactory {
    private static ServerlessJobManager manager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerlessJobManager getManager() {
        if (manager != null) return manager;
        Class<ServerlessJobManager> clazz = ServerlessJobManager.class;
        synchronized (ServerlessJobManager.class) {
            String serverlessType = System.getProperty("serverless.type");
            if ("local".equalsIgnoreCase(serverlessType)) {
                manager = new ServerlessLocalJobManager();
            } else if ("mservice".equalsIgnoreCase(serverlessType)) {
                manager = new ServerlessMServiceJobManager();
            } else if ("aws".equalsIgnoreCase(serverlessType)) {
                manager = new ServerlessAWSJobManager();
            } else if ("hw".equalsIgnoreCase(serverlessType)) {
                manager = new ServerlessHWJobManager();
            } else if ("custom".equalsIgnoreCase(serverlessType) && System.getProperty("serverless.manager.class") != null) {
                try {
                    Class<?> mclass = Class.forName(System.getProperty("serverless.manager.class"));
                    manager = (ServerlessJobManager)mclass.newInstance();
                }
                catch (Exception e) {
                    throw new ServerlessException("get serverless mananger error! ", (Throwable)e);
                }
            } else {
                manager = new ServerlessLocalJobManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }
}

