/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.service;

import java.util.concurrent.locks.LockSupport;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.serverless.core.ServerlessJobExecuter;
import kd.bos.threads.ThreadPools;

public class ServerlessService
implements Service {
    private static Log log = LogFactory.getLog(ServerlessService.class);

    public String getName() {
        return "ServerlessService";
    }

    public boolean isStarted() {
        return false;
    }

    public void start() {
        if (Boolean.getBoolean("serverless.service.enable")) {
            this._start();
        }
    }

    private void _start() {
        String jobid = System.getProperty("serverless.jobid");
        ThreadPools.executeOnce((String)("ServerlessJob-" + jobid), (Runnable)new ServerlessJobExecuter(jobid, () -> {
            log.error("Execute System.exit(1), Starting to exit the service");
            LockSupport.parkNanos(2000000000L);
            System.exit(1);
        }));
    }

    public void stop() {
    }
}

