/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverless.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import kd.bos.serverless.api.ServerlessException;
import kd.bos.serverless.core.MessageSidecar;
import kd.bos.serverless.support.Serde;

public class JavaSerde
extends Serde {
    private static final String CHARSET_ISO = "ISO-8859-1";
    private static final Serde instance = new JavaSerde();

    public static Serde get() {
        return instance;
    }

    @Override
    public String edcode(Serializable message) {
        try {
            return JavaSerde.serializeToString(message);
        }
        catch (Exception e) {
            throw new ServerlessException("encode serverless message error: ", (Throwable)e);
        }
    }

    @Override
    public MessageSidecar decode(String message) {
        try {
            return (MessageSidecar)JavaSerde.deserializeToObject(message);
        }
        catch (Exception e) {
            throw new ServerlessException("decode serverless message error: ", (Throwable)e);
        }
    }

    private static String serializeToString(Object obj) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(obj);
        return byteOut.toString(CHARSET_ISO);
    }

    private static Object deserializeToObject(String str) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(str.getBytes(CHARSET_ISO));
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        return objIn.readObject();
    }
}

