/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dlock.DLockType;
import kd.bos.dlock.config.DLockConfig;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class DLockInfo {
    private SimpleDateFormat sdf = null;
    private String key;
    private String storePath;
    private String instance;
    private String instanceThread;
    private String desc;
    private String ephemeralOwner;
    private Date createTime;
    private long pttl;
    private int waitingLocks;

    @SdkInternal
    public DLockInfo(String key, String storePath, String desc, long ephemeralOwner, long createTime, long pttl, int waitingLocks) {
        int i;
        this.key = key;
        this.storePath = storePath;
        this.desc = "";
        this.instanceThread = "";
        this.instance = "";
        if (DLockConfig.getDLockType() == DLockType.redis && desc != null && (i = desc.indexOf(35)) != -1) {
            desc = desc.substring(i + 1);
        }
        if (desc != null) {
            i = desc.indexOf(35);
            if (i == -1) {
                this.desc = desc;
            } else {
                this.instance = desc.substring(0, i);
                if (i != desc.length() - 1) {
                    this.desc = desc.substring(i + 1);
                    i = this.desc.indexOf(35);
                    if (i != -1) {
                        this.instanceThread = this.desc.substring(0, i);
                        if (!DLockConfig.isDescWithThread()) {
                            this.desc = i != this.desc.length() - 1 ? this.desc.substring(i + 1) : "";
                        }
                    }
                }
            }
        }
        this.ephemeralOwner = Long.toHexString(ephemeralOwner);
        this.createTime = new Date(createTime);
        this.pttl = pttl;
        this.waitingLocks = waitingLocks;
    }

    void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public String getOwner() {
        return this.ephemeralOwner;
    }

    public String getInstanceThread() {
        return this.instanceThread;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public int getWaitingLocks() {
        return this.waitingLocks;
    }

    @SdkInternal
    public long getPttl() {
        return this.pttl;
    }

    public String getInstance() {
        return this.instance;
    }

    public String toString() {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
        return "{key: " + this.key + ", desc: " + this.desc + ", waitingLocks: " + this.waitingLocks + ", createTime: " + this.sdf.format(this.createTime) + ", instance: " + this.instance + ", instanceThread: " + this.instanceThread + ", owner: " + this.ephemeralOwner + ", pttl: " + this.pttl + ", storePath: " + this.storePath + "}";
    }
}

