/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.List;
import kd.bos.dlock.CrossCluster;
import kd.bos.dlock.config.BalanceConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.zk.ZKFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLockUtil {
    private static final Logger log = LoggerFactory.getLogger(DLockUtil.class);
    private static Method getRequestContextMethod;
    private static Method getAccountIdMethod;
    private static String hostAddress;
    private static Method isInstanceAlive;

    private static String getAccountId() {
        try {
            Object rc = getRequestContextMethod.invoke(null, new Object[0]);
            if (rc == null || getAccountIdMethod.invoke(rc, new Object[0]) == null) {
                return "NOACCOUNT";
            }
            return (String)getAccountIdMethod.invoke(rc, new Object[0]);
        }
        catch (Exception e) {
            return "NOACCOUNT";
        }
    }

    public static String getPathPrefix(String prefix) {
        return prefix + DLockUtil.getAccountId();
    }

    public static String getFullPath(String prefix, String lockPath) {
        return (DLockUtil.getPathPrefix(prefix) + '/' + lockPath).replaceAll("//", "/");
    }

    public static String getZKLockRootPath(boolean useVersion2) {
        if (useVersion2) {
            return ZKFactory.getZkRootPath((String)DLockUtil.getZookeeperUrl()) + CrossCluster.getClusterNameForPath() + "/runtime" + "/dlock/";
        }
        return ZKFactory.getZkRootPath((String)DLockUtil.getZookeeperUrl()) + CrossCluster.getClusterNameForPath() + "/runtime" + "/__dlock__";
    }

    public static String getRedisLockRootPath(boolean useVersion2) {
        if (useVersion2) {
            return "/" + CrossCluster.getClusterNameForPath() + "/dlock/";
        }
        return "/" + CrossCluster.getClusterNameForPath() + "/__dlock__";
    }

    public static String getZookeeperUrl() {
        String zookeeper = BalanceConfig.get().isZkSplit() ? System.getProperty("DLock.zookeepers") : System.getProperty("DLock.zookeeper");
        if ((zookeeper == null || zookeeper.trim().length() == 0) && (zookeeper = System.getProperty("configUrl")) == null) {
            zookeeper = "localhost:2181";
            String msg = "Unconfigured key: DLock.zookeeperuse default\uff1a " + zookeeper;
            log.warn(msg);
        }
        return zookeeper;
    }

    public static String getRedisUrl() {
        String url = BalanceConfig.get().isRedisSplit() ? System.getProperty("DLock.redises") : System.getProperty("DLock.redis");
        if ((url == null || url.trim().length() == 0) && (url = System.getProperty("redis.serversForCache")) == null) {
            url = "localhost:6379";
            String msg = "Unconfigured key: redis.serversForCacheuse default\uff1a " + url;
            log.warn(msg);
        }
        return url;
    }

    public static String getHostAddress() {
        return hostAddress;
    }

    public static boolean isInstanceAlive(String instanceId) throws KDException {
        try {
            if (isInstanceAlive == null) {
                Method m = Class.forName("kd.bos.monitor.service.LivingServiceUtils").getMethod("isInstanceAlive", String.class);
                m.setAccessible(true);
                isInstanceAlive = m;
            }
            return (Boolean)isInstanceAlive.invoke(null, instanceId);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getInstanceList() throws KDException {
        try {
            Class<?> eyeUtilsClazz = Class.forName("kd.bos.eye.service.EyeServerService");
            Method m = eyeUtilsClazz.getMethod("getAllInstanceNodesForCrossCluster", String.class);
            List instances = (List)m.invoke(eyeUtilsClazz, CrossCluster.getClusterNameForPath());
            return instances;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("kd.bos.context.RequestContext");
            getRequestContextMethod = cls.getMethod("get", new Class[0]);
            getAccountIdMethod = cls.getMethod("getAccountId", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            hostAddress = Instance.getInstanceId();
        }
        isInstanceAlive = null;
    }
}

