/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.curator;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.config.DLockConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.DisCardUtil;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.WatcherRemoveCuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessMutexPerformance
implements InterProcessLock {
    private static final Logger logger = LoggerFactory.getLogger(InterProcessMutexPerformance.class);
    private static final String LEASE_PARENT = "leases";
    protected final InterProcessSemaphoreV2 semaphore;
    protected final CuratorFramework client;
    private final WatcherRemoveCuratorFramework watcherRemoveClient;
    private volatile Lease lease;
    private final String leasesPath;
    private byte[] valueBytes;

    public InterProcessMutexPerformance(CuratorFramework client, String path) {
        this(client, path, null);
    }

    public InterProcessMutexPerformance(CuratorFramework client, String path, String value) {
        this.client = client;
        this.watcherRemoveClient = client.newWatcherRemoveCuratorFramework();
        this.semaphore = new InterProcessSemaphoreV2((CuratorFramework)this.watcherRemoveClient, path, 1);
        value = DLockUtil.getHostAddress() + '#' + Thread.currentThread() + '#' + (value == null ? "" : value);
        try {
            this.valueBytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.leasesPath = ZKPaths.makePath((String)path, (String)LEASE_PARENT);
    }

    private void setLockDesc() throws Exception {
        this.client.setData().forPath(this.leasesPath + '/' + this.lease.getNodeName(), this.valueBytes);
    }

    public void acquire() throws KDException {
        AtomicInteger retryTimes = new AtomicInteger(0);
        try {
            this.acquireImpl();
        }
        catch (Exception e) {
            this.acquireWithRetry(e, retryTimes, false, -1L, null);
        }
    }

    public boolean acquire(long time, TimeUnit unit) throws KDException {
        AtomicInteger retryTimes = new AtomicInteger(0);
        try {
            return this.acquireImpl(time, unit);
        }
        catch (Exception e) {
            return this.acquireWithRetry(e, retryTimes, true, time, unit);
        }
    }

    private boolean acquireImpl() throws Exception {
        this.lease = this.semaphore.acquire();
        try {
            this.setLockDesc();
        }
        catch (Exception e) {
            try {
                this.lease.close();
            }
            catch (IOException e1) {
                DisCardUtil.discard();
            }
            throw e;
        }
        return true;
    }

    private boolean acquireImpl(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = null;
        acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        try {
            this.setLockDesc();
        }
        catch (Exception e) {
            try {
                this.lease.close();
            }
            catch (IOException e1) {
                DisCardUtil.discard();
            }
            throw e;
        }
        return true;
    }

    private boolean acquireWithRetry(Exception e, AtomicInteger retryTimes, boolean withTime, long time, TimeUnit unit) {
        if (!(e instanceof KeeperException.NoNodeException)) {
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
        if (retryTimes.getAndIncrement() < DLockConfig.getAcquireRetryTimes()) {
            try {
                logger.info(String.format("retry acquire lock %s times for path %s", retryTimes.get(), this.leasesPath));
                this.sleepMilliSeconds(100);
                if (withTime) {
                    return this.acquireImpl(time, unit);
                }
                return this.acquireImpl();
            }
            catch (Exception e1) {
                return this.acquireWithRetry(e, retryTimes, withTime, time, unit);
            }
        }
        logger.info(String.format("retry acquire lock %s times failed for path %s", retryTimes.get(), this.leasesPath));
        throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
    }

    private void sleepMilliSeconds(int milliSeconds) {
        try {
            TimeUnit.MILLISECONDS.sleep(milliSeconds);
        }
        catch (InterruptedException interruptedException) {
            throw new KDException(BosErrorCode.dlock, interruptedException.getMessage(), (Throwable)interruptedException);
        }
    }

    public void release() throws KDException {
        try {
            Lease lease = this.lease;
            Preconditions.checkState((lease != null ? 1 : 0) != 0, (Object)"Not acquired");
            this.lease = null;
            lease.close();
            this.watcherRemoveClient.removeWatchers();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

