/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.curator;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kd.bos.bundle.Resources;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.config.DLockConfig;
import kd.bos.dlock.curator.InterProcessMutexPerformance;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.DisCardUtil;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterProcessMutexStability
extends InterProcessMutexPerformance {
    public static final String LOCK_ACQUIRED = "acquired";
    public static final String DLOCK_PROJECT_NAME = "bos-dlock";
    public static final String REDIS_URL = ConfigurationUtil.getString((String)"redis.serversForSession");
    private static final String ACQUIRED_INSTANCE = Instance.getInstanceId();
    private static final byte[] ACQUIRED_INSTANCE_BYTES = ACQUIRED_INSTANCE.getBytes(StandardCharsets.UTF_8);
    private static final Logger log = LoggerFactory.getLogger(InterProcessMutexStability.class);
    private final String path;
    private final String pathAcquired;
    private boolean acquired = false;
    private final boolean useRedisAcquired;

    public InterProcessMutexStability(CuratorFramework client, String path) {
        this(client, path, null);
    }

    public InterProcessMutexStability(CuratorFramework client, String path, String value) {
        super(client, path, value);
        this.path = path;
        this.pathAcquired = path + '/' + LOCK_ACQUIRED;
        this.useRedisAcquired = DLockConfig.useRedisAcquired();
    }

    @Override
    public void acquire() throws KDException {
        long endTime = System.currentTimeMillis() + DLockConfig.getAcquiredTimeoutMillis();
        this.beforeAcquired();
        super.acquire();
        if (this.useRedisAcquired) {
            this.makeRedisAcquired(endTime);
        } else {
            this.makeAcquired();
        }
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws KDException {
        long endTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(time, unit);
        this.beforeAcquired();
        boolean b = super.acquire(time, unit);
        if (b) {
            if (this.useRedisAcquired) {
                this.makeRedisAcquired(endTime);
            } else {
                this.makeAcquired();
            }
        }
        return b;
    }

    private void beforeAcquired() {
        if (this.acquired) {
            throw new IllegalStateException("Has acquired");
        }
    }

    private void makeAcquired() throws KDException {
        try {
            this.acquired = true;
            if (this.client.checkExists().forPath(this.pathAcquired) != null) {
                this.checkExistsPath();
            }
            this.client.create().forPath(this.pathAcquired, ACQUIRED_INSTANCE_BYTES);
        }
        catch (Exception e) {
            try {
                this.release();
            }
            catch (Exception e1) {
                DisCardUtil.discard();
            }
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
    }

    private void makeRedisAcquired(long endTime) {
        this.acquired = true;
        try (TraceSpan span = Tracer.create((String)"RedisSessionableCache", (String)"DLockMakeAcquired");
             JedisClient jedisClient = RedisFactory.getJedisClient((String)REDIS_URL);){
            String instanceData = jedisClient.get(this.pathAcquired);
            if (instanceData != null) {
                this.checkExistsRedisKey(jedisClient, instanceData, endTime);
            }
            jedisClient.setex(this.pathAcquired, DLockConfig.getExpireTimeout(), ACQUIRED_INSTANCE);
        }
        catch (Exception e) {
            try {
                this.release();
            }
            catch (Exception e1) {
                DisCardUtil.discard();
            }
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExistsRedisKey(JedisClient jedisClient, String instanceData, long endTime) throws Exception {
        boolean neednotReleaseEphemeral = false;
        boolean noException = false;
        try {
            if (ACQUIRED_INSTANCE.equals(instanceData)) {
                long wait = endTime - System.currentTimeMillis();
                if (wait >= 0L) {
                    this.millisecondSleep(wait);
                    if (!jedisClient.exists(this.pathAcquired).booleanValue()) {
                        neednotReleaseEphemeral = true;
                        noException = true;
                    }
                }
            } else if (!DLockUtil.isInstanceAlive(instanceData)) {
                neednotReleaseEphemeral = true;
                noException = true;
                jedisClient.del(this.pathAcquired);
            } else {
                long wait = endTime - System.currentTimeMillis();
                if (wait >= 0L) {
                    this.millisecondSleep(wait);
                    if (!jedisClient.exists(this.pathAcquired).booleanValue()) {
                        neednotReleaseEphemeral = true;
                        noException = true;
                    }
                }
            }
            if (!noException) {
                throw new RuntimeException(Resources.get((String)DLOCK_PROJECT_NAME, (String)"InterProcessMutexStability_3", (String)"\u6301\u6709\u9501\u7684\u670d\u52a1\u8282\u70b9(InstanceId=%1$s)ZK\u66fe\u4e2d\u65ad\uff0c\u672a\u6b63\u786e\u91ca\u653e\u9501:%2$s\uff0c\u672c\u8282\u70b9(%3$s)\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5(\u7b49\u5f85\u91ca\u653e)\u6216\u8bf7\u8fdbmonitor\u89e3\u9501\u3002", (Object[])new Object[]{instanceData, this.path, ACQUIRED_INSTANCE}));
            }
        }
        finally {
            if (!neednotReleaseEphemeral) {
                super.release();
            }
        }
    }

    private void millisecondSleep(long wait) throws InterruptedException {
        Thread.sleep(wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExistsPath() throws Exception {
        boolean neednotReleaseEphemeral = false;
        try {
            byte[] data = (byte[])this.client.getData().forPath(this.pathAcquired);
            if (Arrays.equals(data, ACQUIRED_INSTANCE_BYTES)) {
                throw new RuntimeException(Resources.get((String)DLOCK_PROJECT_NAME, (String)"InterProcessMutexStability_0", (String)"\u6301\u6709\u9501\u7684\u670d\u52a1\u8282\u70b9(InstanceId=%1$s\uff0c\u672c\u8282\u70b9)ZK\u66fe\u4e2d\u65ad\uff0c\u672a\u6b63\u786e\u91ca\u653e\u9501:%2$s\uff0c\u8bf7\u91cd\u8bd5(\u7b49\u5f85\u91ca\u653e)\u6216\u8bf7\u8fdbmonitor\u89e3\u9501\u3002", (Object[])new Object[]{ACQUIRED_INSTANCE, this.path}));
            }
            String ownerInstanceId = new String(data, StandardCharsets.UTF_8);
            if (DLockUtil.isInstanceAlive(ownerInstanceId)) {
                throw new RuntimeException(Resources.getString((String)DLOCK_PROJECT_NAME, (String)"InterProcessMutexStability_3", (Object[])new Object[]{ownerInstanceId, this.path, ACQUIRED_INSTANCE}));
            }
            neednotReleaseEphemeral = true;
            this.client.delete().forPath(this.pathAcquired);
        }
        finally {
            if (!neednotReleaseEphemeral) {
                super.release();
            }
        }
    }

    @Override
    public void release() throws KDException {
        block26: {
            if (!this.acquired) {
                throw new IllegalStateException("Not acquired");
            }
            if (this.useRedisAcquired) {
                try (JedisClient jedisClient = RedisFactory.getJedisClient((String)REDIS_URL);){
                    jedisClient.del(this.pathAcquired);
                    break block26;
                }
                catch (Exception e) {
                    throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
                }
                finally {
                    this.acquired = false;
                    super.release();
                }
            }
            try {
                ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(this.pathAcquired);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("release exception:{}", (Object)e.getMessage());
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
            }
            finally {
                this.acquired = false;
                super.release();
            }
        }
    }
}

