/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.redis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.Resources;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.dlock.DLockManager;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.redis.RedisClientSplit;
import kd.bos.dlock.redis.RedisLocker;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisTracker;
import kd.bos.redis.pool.Pool0;
import kd.bos.redis.pool.Pool0BuilderImpl;
import kd.bos.redis.wrapper.Wrapper;

public class RedisLockManager
implements DLockManager {
    private static final ThreadLocal<Map<String, ReentrantDLock>> thReentrantDLock = ThreadLocal.withInitial(() -> new HashMap());
    private static ConcurrentHashMap<String, Pool0<?>> poolMap = new ConcurrentHashMap();
    private final String rootPath;
    private final RedisClientSplit redisClients;

    static JedisClient getOrCreate(String url) {
        Pool0 pool = poolMap.computeIfAbsent(url, key -> {
            try {
                return Pool0BuilderImpl.getPool((String)Encrypters.decode((String)key));
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{Resources.getString((String)"bos-dlock", (String)"RedisLockManager_0", (Object[])new Object[0])});
            }
        });
        try {
            Object resource = pool.getResource();
            return (JedisClient)RedisTracker.track((Object)Wrapper.wrap((Object)resource));
        }
        catch (Exception e) {
            String msg = "Get JedisClient error: " + e.getMessage() + ",trackMessage:" + RedisTracker.getTrackMessage();
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{msg});
        }
    }

    static JedisClient getOrCreateForKeeper(String url) {
        return RedisLockManager.getOrCreate(url);
    }

    public RedisLockManager(String url, String rootPath) {
        this.rootPath = rootPath;
        this.redisClients = new RedisClientSplit(url);
    }

    private JedisClient createJedis(String lockPath) {
        return this.redisClients.getBalanceClient(lockPath);
    }

    private JedisClient createJedisForKeeper(String lockPath) {
        return this.redisClients.getBalanceClient(lockPath);
    }

    @Override
    public DLock createLock(String lockPath, String lockDesc, boolean reentrant) {
        if (reentrant) {
            String fullPath = DLockUtil.getFullPath(this.rootPath, lockPath);
            ReentrantDLock rd = thReentrantDLock.get().get(fullPath);
            if (rd != null) {
                return rd.lock;
            }
        }
        RedisLocker locker = new RedisLocker(() -> this.createJedis(lockPath), () -> this.createJedisForKeeper(lockPath), lockPath, lockDesc, this.rootPath);
        String fullPath = DLockUtil.getFullPath(this.rootPath, lockPath);
        if (reentrant) {
            ReentrantDLock rd = new ReentrantDLock(locker);
            locker.setReentrantDLock(rd);
            thReentrantDLock.get().put(fullPath, rd);
        }
        return locker;
    }

    @Override
    public Map<String, DLockInfo> getAllLockInfo() {
        HashMap<String, DLockInfo> map = new HashMap<String, DLockInfo>();
        List<JedisClient> clients = this.redisClients.getClients();
        for (int i = 0; i < clients.size(); ++i) {
            try (JedisClient jedis = clients.get(i);){
                RedisLocker.getAllLockInfo(jedis, this.rootPath).forEach((key, dlockInfo) -> map.putIfAbsent((String)key, (DLockInfo)dlockInfo));
                continue;
            }
            catch (Exception e) {
                throw new KDException(BosErrorCode.jedisException, "dlock key:" + this.rootPath + " to getAllLockInfo failed", (Throwable)e);
            }
        }
        return map;
    }

    @Override
    public DLockInfo getLockInfo(String key) {
        try (JedisClient jedis = this.redisClients.getBalanceClient(key);){
            DLockInfo dLockInfo = RedisLocker.getLockInfo(jedis, key, this.rootPath);
            return dLockInfo;
        }
    }

    @Override
    public void forceUnlock(String ... keys) {
        for (String key : keys) {
            try (JedisClient jedis = this.redisClients.getBalanceClient(key);){
                RedisLocker.forceUnlock(jedis, this.rootPath, key);
            }
        }
    }

    @Override
    public void forceClear(String ... keys) {
        for (String key : keys) {
            try (JedisClient jedis = this.redisClients.getBalanceClient(key);){
                RedisLocker.forceClear(jedis, this.rootPath, keys);
            }
        }
    }

    static class ReentrantDLock {
        private DLock lock;
        private int ref;

        ReentrantDLock(DLock lock) {
            this.lock = lock;
            this.ref = 0;
        }

        void incRef() {
            ++this.ref;
        }

        void decRef() {
            --this.ref;
        }

        boolean canRelease() {
            return this.ref <= 0;
        }

        void release(String lockKey) {
            ((Map)thReentrantDLock.get()).remove(lockKey);
        }
    }
}

