/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.redis;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import kd.bos.dlock.AbstractDLock;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.redis.RedisLockKeeper;
import kd.bos.dlock.redis.RedisLockManager;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.util.DisCardUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLocker
extends AbstractDLock
implements DLock,
Comparable<RedisLocker> {
    private static final Logger log = LoggerFactory.getLogger(RedisLocker.class);
    private static final String ACQUIRED_INSTANCE = Instance.getInstanceId();
    static final long defaultExpireTime = 300000L;
    private static final String FIELD_DESC = "desc";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_WAITING_LOCKS = "waitingLocks";
    private static final String FIELD_CREATE_TIME = "createTime";
    private static final String LOCK_SET_SCRIPT = "redis.call('pexpire', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], 'desc', ARGV[2]); redis.call('hset', KEYS[1], 'createTime', ARGV[3]); redis.call('hset', KEYS[1], 'owner', ARGV[4]); local waitLock = tonumber(redis.call('hget', KEYS[1] ,'waitingLocks')); if waitLock ~= nil and waitLock > 0 then   redis.call('hincrBy', KEYS[1], 'waitingLocks', -1); end;";
    private static final String UNLOCK_SCRIPT = "local waitingLocks=tonumber(redis.call('hget', KEYS[1] ,'waitingLocks')); local field = ARGV[1];local threadId=redis.call('hget', KEYS[1], 'owner');if threadId~=nil and threadId==field then if waitingLocks==nil or waitingLocks<= 0 then redis.call('del', KEYS[1]) else redis.call('hdel', KEYS[1], 'desc') end;end;";
    private static final String FORCE_UNLOCK_SCRIPT = "local waitingLocks=tonumber(redis.call('hget', KEYS[1] ,'waitingLocks')); if waitingLocks==nil or waitingLocks<= 0 then redis.call('del', KEYS[1]) else redis.call('hdel', KEYS[1], 'desc') end";
    private static final String RELEASE_NOT_LIVE_SCRIPT = "local field = ARGV[1];local instanceId = redis.call('hget', KEYS[1], KEYS[2]); if instanceId ~= nil and instanceId ~= ' ' then local index = string.find(instanceId, '#');instanceId = index and string.sub(instanceId, 1, index -1) or instanceId;if instanceId==field then redis.call('HDEL', KEYS[1], KEYS[2]); local waitLock = tonumber(redis.call('hget', KEYS[1] ,'waitingLocks'));if waitLock ~= nil and waitLock > 0 then redis.call('hincrBy', KEYS[1], 'waitingLocks', -1);end;end;end;";
    private static final String WAITING_LOCKS_WAITING_DECR = "local waitLock = tonumber(redis.call('hget', KEYS[1] ,'waitingLocks'));if waitLock ~= nil and waitLock > 0 then  redis.call('hincrBy', KEYS[1], 'waitingLocks', -1);end;";
    private static final long MIN_EXPIRE_TIME = 30000L;
    private static final long MAX_RETRY_INTERVAL = 1000L;
    private static final ThreadLocal<SimpleDateFormat> TH_SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    private long expireTime;
    private Supplier<JedisClient> jedisCreator;
    private Supplier<JedisClient> keeperAloneJedis;
    private String lockKey;
    private String lockDesc;
    private volatile boolean acquired = false;
    private final Object unlockObj = new Object();
    private RedisLockManager.ReentrantDLock rd;
    private final String rootPath;

    private static String now() {
        return TH_SDF.get().format(new Date());
    }

    public RedisLocker(Supplier<JedisClient> jedisCreator, Supplier<JedisClient> keeperAloneJedis, String lockKey, String lockDesc, String keyPrefix) {
        this(jedisCreator, keeperAloneJedis, lockKey, lockDesc, keyPrefix, 300000L);
    }

    public RedisLocker(Supplier<JedisClient> jedisCreator, Supplier<JedisClient> keeperAloneJedis, String lockKey, String lockDesc, String keyPrefix, long expireTime) {
        if (expireTime < 30000L) {
            expireTime = 30000L;
        }
        Objects.requireNonNull(lockKey, "Lock key can not be null.");
        this.jedisCreator = jedisCreator;
        this.keeperAloneJedis = keeperAloneJedis;
        this.rootPath = keyPrefix;
        this.lockKey = DLockUtil.getFullPath(keyPrefix, lockKey);
        this.lockDesc = ACQUIRED_INSTANCE + '#' + DLockUtil.getHostAddress() + '#' + Thread.currentThread() + '#' + (lockDesc == null ? "" : lockDesc);
        this.expireTime = expireTime;
    }

    @Override
    public String[] getLockAccountIds() {
        try (JedisClient jedis = this.jedisCreator.get();){
            String[] stringArray;
            Set accountIds = jedis.keys(this.rootPath + "*");
            if (accountIds.isEmpty()) {
                String[] stringArray2 = empty_strings;
                return stringArray2;
            }
            TreeSet<String> ret = new TreeSet<String>();
            for (String key : accountIds) {
                int i = (key = key.substring(this.rootPath.length())).indexOf(47);
                if (i == -1) continue;
                ret.add(key.substring(0, i));
            }
            if (ret.isEmpty()) {
                stringArray = empty_strings;
                return stringArray;
            }
            stringArray = ret.toArray(new String[ret.size()]);
            return stringArray;
        }
    }

    public void setReentrantDLock(RedisLockManager.ReentrantDLock rd) {
        this.rd = rd;
    }

    boolean touchExpire() {
        try (JedisClient jedis = this.keeperAloneJedis.get();){
            boolean bl = 1L == jedis.pexpire(this.lockKey, this.expireTime);
            return bl;
        }
    }

    long pttl() {
        try (JedisClient jedis = this.jedisCreator.get();){
            long l = jedis.pttl(this.lockKey);
            return l;
        }
    }

    long getExpireTime() {
        return this.expireTime;
    }

    @Override
    public void lock() {
        this.tryLock(Long.MAX_VALUE);
    }

    @Override
    public boolean tryLock() {
        return this.tryLock(1L);
    }

    @Override
    public boolean tryLock(long msTimeout) {
        boolean reentry = false;
        if (this.rd != null) {
            reentry = true;
            if (this.rd.canRelease()) {
                this.rd.incRef();
            } else {
                this.rd.incRef();
                return true;
            }
        }
        if (this.acquired) {
            throw new IllegalStateException("Has acquired");
        }
        log.info("acquire lock " + this.lockKey + "..." + (reentry ? " reentryDLock" : ""));
        try (JedisClient jedis = this.jedisCreator.get();){
            jedis.hincrBy(this.lockKey, FIELD_WAITING_LOCKS, 1L);
            long sleep = Math.min(msTimeout, 1000L);
            long ts = System.currentTimeMillis();
            while (jedis.hsetnx(this.lockKey, FIELD_DESC, ACQUIRED_INSTANCE) != 1L) {
                String instanceId = jedis.hget(this.lockKey, FIELD_DESC);
                if (instanceId != null) {
                    int i = instanceId.indexOf(35);
                    if (i != -1) {
                        instanceId = instanceId.substring(0, i);
                    }
                    if (!ACQUIRED_INSTANCE.equals(instanceId)) {
                        log.info(String.format("check lock %s instance %s if alive before...", this.lockKey, instanceId));
                        if (!DLockUtil.isInstanceAlive(instanceId)) {
                            log.info(String.format("del lock %s during instance %s dead...", this.lockKey, instanceId));
                            jedis.eval(RELEASE_NOT_LIVE_SCRIPT, 2, new String[]{this.lockKey, FIELD_DESC, instanceId});
                            continue;
                        }
                        log.info(String.format("check lock %s instance %s still alive...", this.lockKey, instanceId));
                    }
                }
                if (sleep > 0L) {
                    try {
                        jedis.close();
                        Thread.sleep(sleep);
                        jedis = this.jedisCreator.get();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (System.currentTimeMillis() - ts < msTimeout) continue;
                jedis.eval(WAITING_LOCKS_WAITING_DECR, 1, new String[]{this.lockKey});
                boolean bl = false;
                return bl;
            }
            this.acquired = true;
            jedis.eval(LOCK_SET_SCRIPT, 1, new String[]{this.lockKey, String.valueOf(this.expireTime), this.lockDesc, RedisLocker.now(), String.valueOf(Thread.currentThread().getId())});
            log.info("acquired lock " + this.lockKey + (reentry ? " reentryDLock" : ""));
        }
        RedisLockKeeper.keep(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        if (!this.acquired) {
            return;
        }
        log.info("release lock " + this.lockKey + "...");
        if (this.rd != null) {
            this.rd.decRef();
            if (!this.rd.canRelease()) {
                return;
            }
            this.rd.release(this.lockKey);
        }
        if (this.acquired) {
            Object object = this.unlockObj;
            synchronized (object) {
                try (JedisClient jedis = this.jedisCreator.get();){
                    if (this.acquired) {
                        this.acquired = false;
                        jedis.eval(UNLOCK_SCRIPT, 1, new String[]{this.lockKey, String.valueOf(Thread.currentThread().getId())});
                        RedisLockKeeper.unkeep(this);
                    }
                }
                catch (Exception e) {
                    log.info("release lock failed " + this.lockKey + "...");
                    throw e;
                }
            }
        }
    }

    @Override
    public void close() {
        this.unlock();
    }

    @Override
    public DLock fastMode() {
        return this;
    }

    @Override
    public DLock stableMode() {
        return this;
    }

    @Override
    public int compareTo(RedisLocker o) {
        return this.lockKey.compareTo(o.lockKey);
    }

    static DLockInfo getLockInfo(JedisClient jedis, String lockKey, String keyPrefix) {
        String fullLockKey = DLockUtil.getFullPath(keyPrefix, lockKey);
        Map map = jedis.hgetAll(fullLockKey);
        if (!map.isEmpty()) {
            String createTime = (String)map.get(FIELD_CREATE_TIME);
            String desc = (String)map.get(FIELD_DESC);
            String owner = (String)map.get(FIELD_OWNER);
            String waitingLocks = (String)map.get(FIELD_WAITING_LOCKS);
            long n_owner = owner == null ? 0L : Long.parseLong(owner);
            long n_createTime = 0L;
            try {
                n_createTime = createTime == null ? 0L : TH_SDF.get().parse(createTime).getTime();
            }
            catch (ParseException e) {
                DisCardUtil.discard();
            }
            int n_waitingLocks = waitingLocks == null ? 0 : Integer.parseInt(waitingLocks);
            long pttl = jedis.pttl(fullLockKey);
            return new DLockInfo(lockKey, fullLockKey, desc, n_owner, n_createTime, pttl, n_waitingLocks);
        }
        return null;
    }

    static Map<String, DLockInfo> getAllLockInfo(JedisClient jedis, String keyPrefix) {
        String prefix = DLockUtil.getPathPrefix(keyPrefix);
        int len = prefix.length();
        HashMap<String, DLockInfo> map = new HashMap<String, DLockInfo>();
        for (String fullLockKey : jedis.keys(prefix + "*")) {
            String lockKey = fullLockKey.substring(len);
            DLockInfo lock = RedisLocker.getLockInfo(jedis, lockKey, keyPrefix);
            if (lock == null) continue;
            map.put(lockKey, lock);
        }
        return map;
    }

    static void forceUnlock(JedisClient jedis, String rootPath, String ... keys) {
        for (String key : keys) {
            String fullLockKey = DLockUtil.getFullPath(rootPath, key);
            log.info("unlock path :" + fullLockKey);
            jedis.eval(FORCE_UNLOCK_SCRIPT, 1, new String[]{fullLockKey});
        }
    }

    static void forceClear(JedisClient jedis, String rootPath, String ... keys) {
        for (String key : keys) {
            log.info("clear lock path :" + keys);
            RedisLocker.forceUnlock(jedis, rootPath, key);
            while (RedisLocker.getLockInfo(jedis, key, rootPath) != null) {
                RedisLocker.forceUnlock(jedis, rootPath, key);
            }
        }
    }
}

