/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.dlock.service;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dlock.AbstractDLock;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockType;
import kd.bos.dlock.DLockUtil;
import kd.bos.dlock.config.DLockConfig;
import kd.bos.dlock.curator.ZookeeperClientSplit;
import kd.bos.util.DisCardUtil;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLockCleanThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DLockCleanThread.class);
    private static final String DIR_SPLIT = "/";
    private final Map<String, CronTrigger> cronMap = new ConcurrentHashMap<String, CronTrigger>(2);

    public DLockCleanThread(String name) {
        super(name);
    }

    @Override
    public void run() {
        long minuteTS = 60000L;
        ZonedDateTime beginTime = ZonedDateTime.now().truncatedTo(ChronoUnit.MINUTES);
        while (!Thread.interrupted()) {
            String cleanCronExpression = DLockConfig.getCleanCron();
            CronTrigger cronTrigger = this.cronMap.computeIfAbsent(cleanCronExpression, k -> {
                String cronExpress = k;
                if (!CronExpression.isValidExpression((String)cronExpress)) {
                    cronExpress = "0 0 1 5,10,15,20,25 * ?";
                    log.warn("DLock cleanCronExpression invalid,use default cron:" + cronExpress);
                }
                return (CronTrigger)TriggerBuilder.newTrigger().withIdentity("DLockCleanCronExpress").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpress)).build();
            });
            long ts = System.currentTimeMillis();
            ZonedDateTime nextBeginTime = beginTime.plusMinutes(1L);
            Date fireTime = cronTrigger.getFireTimeAfter(Date.from(beginTime.toInstant()));
            if (!fireTime.after(Date.from(nextBeginTime.toInstant()))) {
                this.fireClean();
            }
            beginTime = nextBeginTime;
            if ((ts = 60000L + ts - System.currentTimeMillis()) <= 0L || this.snoopRound(ts)) continue;
            break;
        }
    }

    private boolean snoopRound(long ts) {
        try {
            Thread.sleep(ts);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private void fireClean() {
        if (DLockConfig.isdLockVersion2() && DLockConfig.dLockCleanEnable() && DLockType.zookeeper == DLockConfig.getDLockType()) {
            DLock dLock = DLock.create("dLockClean");
            String[] lockAccountIds = ((AbstractDLock)dLock).getLockAccountIds();
            ZookeeperClientSplit zkClient = new ZookeeperClientSplit(DLockUtil.getZookeeperUrl());
            if (lockAccountIds.length > 0) {
                for (CuratorFramework client : zkClient.getClients()) {
                    for (String accountId : lockAccountIds) {
                        String path = DLockUtil.getZKLockRootPath(false) + accountId;
                        if (null == path) continue;
                        try {
                            this.deleteLeafChildrenPath(client, path);
                        }
                        catch (Exception e) {
                            log.warn("DLock clean failed:" + e.getMessage(), (Throwable)e);
                            DisCardUtil.discard();
                        }
                    }
                }
            }
        }
    }

    private void deleteLeafChildrenPath(CuratorFramework client, String path) {
        if (path != null) {
            try {
                List childrenKeys = (List)client.getChildren().forPath(path);
                if (!childrenKeys.isEmpty()) {
                    for (String childrenKey : childrenKeys) {
                        String childrenPath = path + DIR_SPLIT + childrenKey;
                        this.deleteLeafChildrenPath(client, childrenPath);
                    }
                }
                this.deletePath(client, path);
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
        }
    }

    private void deletePath(CuratorFramework client, String path) {
        try {
            ((ChildrenDeletable)client.delete().guaranteed()).deletingChildrenIfNeeded().forPath(path);
            Thread.sleep(50L);
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }
}

