/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.config.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.config.client.ConfigService;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.config.client.abc.ABCConfiguration;
import kd.bos.config.client.abc.ApplicationPropertiesConfiguration;
import kd.bos.config.client.abc.SystemEnvConfiguration;
import kd.bos.config.client.abc.SystemPropertiesConfiguration;
import kd.bos.config.client.abc.SystemPropertySetter;
import kd.bos.config.client.adapter.CommonConfiguration;
import kd.bos.config.client.impl.ConfigurationFactoryNew;
import kd.bos.config.client.impl.MicroKernelConfiguration;
import kd.bos.config.client.impl._Properties;
import kd.bos.config.client.var.VarChangeListener;
import kd.bos.config.client.var.VarItem;
import kd.bos.config.client.var.VarMap;
import kd.bos.config.client.var.VarProxyConfiguration;
import kd.bos.config.client.var.VarSystemPropertySetter;
import kd.bos.extension.ExtensionFactory;
import kd.bos.util.SystemProperties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.log4j.Logger;

public class MicroKernelConfigurationFactory
extends ConfigurationFactory {
    private ConfigurationFactoryNew base = null;
    private MicroKernelConfiguration selfConfiguration = new MicroKernelConfiguration();
    private static final String CONFIGURLNACOS = "configUrl.nacos";
    private static Logger logger = Logger.getLogger(MicroKernelConfigurationFactory.class);
    private AtomicBoolean inited = new AtomicBoolean(false);
    private String[] configAppName = null;
    private ExtensionFactory<ConfigService> configSpiFactory = ExtensionFactory.getExtensionFacotry(ConfigService.class);
    private VarMap varMap = null;
    private ABCConfiguration abcConfiguration;
    private VarProxyConfiguration globalConfiguration = null;

    public MicroKernelConfigurationFactory() {
        String configUrl = System.getProperty("configUrl");
        if (configUrl != null) {
            this.base = new ConfigurationFactoryNew();
        } else {
            try {
                this.init();
            }
            catch (Error | Exception e) {
                logger.warn((Object)(this.getConfigServiceType() + " init configservice Configuration error ,will use default system properties Configuration"), e);
            }
        }
    }

    protected Configuration _getConfigurationByPath(String arg0) {
        if (this.base != null) {
            return this.base._getConfigurationByPath(arg0);
        }
        throw new RuntimeException("not support _getConfigurationByPath");
    }

    public Configuration _getGlobalConfiguration() {
        if (this.base != null) {
            return this.base._getGlobalConfiguration();
        }
        if (this.inited.compareAndSet(false, true) && System.getProperty("configUrl") == null) {
            System.setProperty("configUrl", System.getProperty("default.zk.url", "localhost:2181"));
        }
        return this.globalConfiguration == null ? this.selfConfiguration : this.globalConfiguration;
    }

    public void _reinit() {
        if (this.base != null) {
            this.base._reinit();
            return;
        }
        if (this.varMap != null) {
            this.varMap.clear();
        }
        if (this.abcConfiguration != null) {
            this.abcConfiguration.clearListeners();
        }
        if (this.globalConfiguration != null) {
            this.globalConfiguration.clearListeners();
        }
        this.init();
    }

    private void init() {
        String[] needPros;
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        String tempConfigCenter = this.getConfigServiceType();
        ConfigService configService = (ConfigService)this.configSpiFactory.getExtension(tempConfigCenter, false);
        this.configAppName = configService.getConfigAppNames();
        for (String needP : needPros = configService.needProperties()) {
            if (System.getProperty(needP) != null && System.getProperty(needP).length() != 0) continue;
            return;
        }
        this.initVar();
        this.initGlobal();
        _Properties p = new _Properties(System.getProperties());
        System.setProperties((Properties)p);
    }

    private void initVar() {
        String tempConfigCenter;
        ExtensionFactory configSpiFactory = ExtensionFactory.getExtensionFacotry(ConfigService.class);
        ConfigService configService = (ConfigService)configSpiFactory.getExtension(tempConfigCenter = this.getConfigServiceType(), false);
        if (configService.getVarConfigName() != null) {
            configService.setConfigAppName(configService.getVarConfigName());
            this.varMap = new VarMap((Configuration)new CommonConfiguration(configService), new VarChangeListener(){

                public void onChange(String refKey, String varName, String varValue) {
                    String value = MicroKernelConfigurationFactory.this.globalConfiguration.getProperty(refKey);
                    if (value != null) {
                        VarItem varItem = (VarItem)MicroKernelConfigurationFactory.this.varMap.get((Object)varName);
                        value = varItem.transform(value);
                        System.setProperty(refKey, value);
                    }
                }
            });
        } else {
            this.varMap = new VarMap((Configuration)new CommonConfiguration(new ConfigService(){

                public String spiName() {
                    return null;
                }

                public void setConfigAppName(String configAppName) {
                }

                public String getConfigAppName() {
                    return null;
                }

                public Iterator<String> keys() {
                    return Collections.emptyIterator();
                }

                public String getProperty(String key, String defaultValue) {
                    return null;
                }

                public String[] needProperties() {
                    return new String[0];
                }

                public String[] getConfigAppNames() {
                    return new String[0];
                }

                public String getVarConfigName() {
                    return null;
                }
            }), new VarChangeListener(){

                public void onChange(String refKey, String varName, String varValue) {
                }
            });
        }
    }

    private String getConfigServiceType() {
        String configCenters = SystemProperties.getWithEnv((String)"configServer.types");
        if (configCenters == null || configCenters.length() == 0) {
            return "springbootnacos";
        }
        return configCenters;
    }

    private void initGlobal() {
        AbstractConfiguration.setDefaultListDelimiter((char)'\u0000');
        ArrayList<Configuration> configurationList = new ArrayList<Configuration>();
        configurationList.add((Configuration)new SystemPropertiesConfiguration());
        configurationList.add((Configuration)new SystemEnvConfiguration());
        configurationList.add((Configuration)new ApplicationPropertiesConfiguration());
        this.loadCommonConfigServer(configurationList);
        VarSystemPropertySetter vps = new VarSystemPropertySetter(this.varMap);
        this.abcConfiguration = new ABCConfiguration(configurationList.toArray(new Configuration[configurationList.size()]), (SystemPropertySetter)vps);
        this.globalConfiguration = new VarProxyConfiguration((Configuration)this.abcConfiguration, this.varMap);
    }

    private void loadCommonConfigServer(List<Configuration> configurationList) {
        String extConfigCenters = this.getConfigServiceType();
        for (int i = 0; i < this.configAppName.length; ++i) {
            String tempConfigAppName = this.configAppName[i];
            ConfigService configService = (ConfigService)this.configSpiFactory.getExtension(extConfigCenters, false);
            configService.setConfigAppName(tempConfigAppName);
            configurationList.add((Configuration)new CommonConfiguration(configService));
        }
    }
}

