/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.rocketmq;

import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.util.StringUtils;
import org.apache.log4j.Logger;

public class RocketmqFactory {
    private static Logger logger = Logger.getLogger(RocketmqFactory.class);
    private static ConcurrentHashMap<String, RocketInfo> rocketInfoMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> REGION_INSTANCENAME_MAP = new ConcurrentHashMap();
    private static final String ROCKETMQ_INSTANCENAME = "defaultInstanceName_";
    private static int maxInstanceNameSize = 2;

    public static String getInstanceName(String region) {
        if (REGION_INSTANCENAME_MAP.containsKey(region)) {
            return REGION_INSTANCENAME_MAP.get(region);
        }
        String key = region;
        if (region.equals("schedule") && Boolean.getBoolean("mq.rocketmq.schedule.instancename.alone.enable")) {
            key = "scheduleInstanceName";
        }
        int index = Math.abs(region.hashCode() % maxInstanceNameSize);
        String value = ROCKETMQ_INSTANCENAME + index;
        REGION_INSTANCENAME_MAP.putIfAbsent(key, value);
        return value;
    }

    public static RocketInfo getRocketInfo(String serverKey) {
        RocketInfo rocketInfo = rocketInfoMap.get(serverKey);
        if (rocketInfo != null) {
            return rocketInfo;
        }
        Class<RocketmqFactory> clazz = RocketmqFactory.class;
        synchronized (RocketmqFactory.class) {
            if (rocketInfoMap.containsKey(serverKey)) {
                rocketInfo = rocketInfoMap.get(serverKey);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return rocketInfo;
            }
            try {
                rocketInfo = RocketmqFactory.createRocketInfo(serverKey);
                rocketInfoMap.put(serverKey, rocketInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return rocketInfo;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.rocketmqConfiguration, new Object[]{e.getMessage()});
            }
        }
    }

    private static RocketInfo createRocketInfo(String serverKey) {
        String serverInfo = System.getProperty(serverKey);
        if (serverInfo == null) {
            logger.error((Object)("rocket server not config for " + serverKey));
            throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"rocket server not config for " + serverKey});
        }
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
            RocketInfo rocketInfo = new RocketInfo();
            String str = Objects.requireNonNull(prop.getProperty("host"), "rocket host can't be empty.");
            rocketInfo.setHost(str);
            str = prop.getProperty("user");
            rocketInfo.setUsername(str);
            str = prop.getProperty("password");
            str = Encrypters.decode((String)str);
            rocketInfo.setPassword(str);
            str = Objects.requireNonNull(prop.getProperty("vhost"), "rocket vhost can't be empty.");
            rocketInfo.setVhost(str);
            str = prop.getProperty("clustername");
            if (StringUtils.isEmpty((String)str)) {
                str = System.getProperty("mq.rocketmq.clustername", "DefaultCluster");
            }
            rocketInfo.setClustername(str);
            return rocketInfo;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqConfiguration, new Object[]{e.getMessage()});
        }
    }

    static {
        Integer maxSize = Integer.getInteger("mq.rocketmq.instancename.max.size", maxInstanceNameSize);
        maxInstanceNameSize = Math.max(maxSize, maxInstanceNameSize);
    }
}

