/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.serverscript.manager.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.ScriptLookup;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.serverscript.manager.ScriptManager;
import kd.bos.serverscript.manager.impl.JarBaseSystemScriptManager;
import kd.bos.serverscript.manager.impl.ScriptLookupImpl;
import org.apache.commons.io.IOUtils;

public class FileBaseManager
implements ScriptManager {
    private final String dir;

    public FileBaseManager(String dir) {
        this.dir = dir;
        new File(dir).mkdirs();
    }

    @Override
    public void addCustomScript(String name, String content, Map<String, String> properties) {
        String fileName = this.dir + "/" + name + ".js";
        try {
            FileBaseManager.writeFile(fileName, content, "UTF-8");
        }
        catch (Exception t) {
            throw new ScriptException("Can't add script named " + name);
        }
    }

    @Override
    public void deleteCustomScript(String name) {
        String fileName = this.dir + "/" + name + ".js";
        new File(fileName).delete();
    }

    @Override
    public ScriptInfo getCustomScript(String name) {
        try {
            String fileName = this.dir + "/" + name + ".js";
            String content = FileBaseManager.getFileContent(fileName);
            return new SimpleScriptInfo(name, content);
        }
        catch (Exception t) {
            throw new ScriptException("Can't get script named " + name, (Throwable)t);
        }
    }

    @Override
    public List<ScriptInfo> getAllCustomScripts() {
        File[] files;
        File root = new File(this.dir);
        if (root.exists() && root.isDirectory() && (files = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".js");
            }
        })) != null && files.length > 0) {
            try {
                return this.files2ScriptInfoList(files);
            }
            catch (Exception t) {
                throw new ScriptException("Can't get scripts.", (Throwable)t);
            }
        }
        return Collections.emptyList();
    }

    private List<ScriptInfo> files2ScriptInfoList(File[] files) throws IOException {
        ArrayList<ScriptInfo> list = new ArrayList<ScriptInfo>(files.length);
        for (File file : files) {
            String name = file.getName().substring(0, file.getName().length() - 4);
            String content = FileBaseManager.getFileContent(file.getCanonicalPath());
            SimpleScriptInfo info = new SimpleScriptInfo(name, content);
            info.setSystem(false);
            list.add((ScriptInfo)info);
        }
        return list;
    }

    @Override
    public List<ScriptInfo> getAllSystemScripts() {
        return JarBaseSystemScriptManager.getAllSystemScripts();
    }

    public static void writeFile(String fileName, String data) throws IOException {
        FileBaseManager.writeFile(fileName, data, "UTF-8");
    }

    public static void writeFile(String fileName, String data, String encoding) throws IOException {
        try (FileOutputStream output = new FileOutputStream(fileName);){
            IOUtils.write((String)data, (OutputStream)output, (String)encoding);
        }
    }

    public static String getContent(InputStream in) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public static String getFileContent(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ScriptLookup getScriptLookup() {
        return new ScriptLookupImpl(this);
    }
}

