/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;

public class JoinQueryParameter {
    private String mainEntity;
    private List<JoinQuery> joinQueryList = new ArrayList<JoinQuery>();
    private String selectFields;
    private String orderBys;
    private int pageStart;
    private int pageLimit;
    private QFilter[] filters;

    public JoinQueryParameter(String mainEntity) {
        this.mainEntity = mainEntity;
    }

    public String getMainEntity() {
        return this.mainEntity;
    }

    public List<JoinQuery> getJoinQueryList() {
        return this.joinQueryList;
    }

    public void addJoinQuery(JoinQuery joinQuery) {
        this.joinQueryList.add(joinQuery);
    }

    public String getSelect() {
        return this.selectFields;
    }

    public int getStart() {
        return this.pageStart;
    }

    public JoinQueryParameter start(int start) {
        this.pageStart = start;
        return this;
    }

    public int getLimit() {
        return this.pageLimit;
    }

    public JoinQueryParameter limit(int limit) {
        this.pageLimit = limit;
        return this;
    }

    public JoinQueryParameter select(String selectFields) {
        this.selectFields = selectFields;
        return this;
    }

    public String getOrderBy() {
        return this.orderBys;
    }

    public JoinQueryParameter orderBy(String orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    public QFilter[] getFilter() {
        if (this.filters == null) {
            return new QFilter[0];
        }
        return this.filters;
    }

    public JoinQueryParameter filter(QFilter[] filters) {
        this.filters = filters;
        return this;
    }

    public String toString() {
        return this.mainEntity + this.joinQueryList;
    }

    public static class JoinQuery {
        private String joinEntity;
        private String joinAlias;
        private ORMHint.JoinHint hint = ORMHint.JoinHint.DEFAULT;
        private String propertyName;
        private String joinPropertyName;
        private String andFilterExp;
        private Object[] andFilterExpParams;

        public JoinQuery(String joinEntity) {
            this.joinEntity = joinEntity;
        }

        public String getJoinEntity() {
            return this.joinEntity;
        }

        public String getJoinEntityAlias() {
            if (this.joinAlias != null) {
                return this.joinAlias;
            }
            return this.joinEntity;
        }

        public JoinQuery joinEntityAlias(String joinEntityAlias) {
            this.joinAlias = joinEntityAlias;
            return this;
        }

        public ORMHint.JoinHint getJoinHint() {
            return this.hint;
        }

        public JoinQuery joinHint(ORMHint.JoinHint joinHint) {
            this.hint = joinHint;
            return this;
        }

        public String getProperty() {
            return this.propertyName;
        }

        public JoinQuery property(String property) {
            this.propertyName = property;
            return this;
        }

        public String getJoinProperty() {
            return this.joinPropertyName;
        }

        public JoinQuery joinProperty(String joinProperty) {
            this.joinPropertyName = joinProperty;
            return this;
        }

        public String getAndExp() {
            return this.andFilterExp;
        }

        public JoinQuery andExp(String andExp) {
            this.andFilterExp = andExp;
            return this;
        }

        public JoinQuery andExpParams(Object[] andExpParams) {
            this.andFilterExpParams = andExpParams;
            return this;
        }

        public Object[] getAndExpParams() {
            return this.andFilterExpParams;
        }

        public String toString() {
            return (Object)((Object)this.hint) + " " + this.joinEntity + " ON " + this.joinPropertyName + "=" + this.propertyName + " AND " + this.andFilterExp;
        }
    }
}

