/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class AggregateFuncs {
    private static final String[] supportFuncsArr = new String[]{"sum", "count"};
    private static final Set<String> supportFuncs = new HashSet<String>(Arrays.asList(supportFuncsArr));
    private static final int maxLength = Integer.getInteger("orm.field.alias.maxlength", 22);
    private String[] funcs;
    private String[] fields;
    private String[] aliasFields;
    private String[] customerAlias;

    public AggregateFuncs(String ... functions) {
        this.analyseFuncs(functions);
    }

    public String[] getFuncs() {
        return this.funcs;
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[] getAliasFields() {
        return this.aliasFields;
    }

    public String[] getCustomerAlias() {
        return this.customerAlias;
    }

    public String getSelectFields() {
        HashSet<String> selectFields = new HashSet<String>(this.fields.length);
        for (int i = 0; i < this.fields.length; ++i) {
            selectFields.add(this.fields[i] + " " + this.aliasFields[i]);
        }
        StringBuilder selectFieldsBuilder = new StringBuilder(this.fields.length * 8);
        for (String field : selectFields) {
            selectFieldsBuilder.append(field).append(',');
        }
        return selectFieldsBuilder.substring(0, selectFieldsBuilder.length() - 1);
    }

    private void analyseFuncs(String[] functions) {
        try {
            ArrayList<String> fieldList = new ArrayList<String>(functions.length);
            ArrayList<String> funcList = new ArrayList<String>(functions.length);
            ArrayList<String> aliasFieldList = new ArrayList<String>(functions.length);
            ArrayList<String> customerAliasFieldList = new ArrayList<String>(functions.length);
            int sizeFlag = 0;
            for (String func : functions) {
                String funcType = func.substring(0, func.indexOf(40)).toLowerCase();
                if (!supportFuncs.contains(funcType)) {
                    throw new KDException("aggregate func not support func=" + func + "the support funcs is " + Arrays.toString(supportFuncsArr));
                }
                String fieldName = func.substring(func.indexOf(40) + 1, func.indexOf(41));
                funcList.add(funcType);
                String[] strArr = fieldName.trim().split(" ");
                fieldName = strArr[0];
                fieldList.add(fieldName);
                String alais = funcType + "_" + fieldName.replaceAll("\\.", "_");
                if (alais.length() > maxLength) {
                    alais = funcType + "_alias_" + sizeFlag;
                }
                aliasFieldList.add(alais);
                String customerAlias = func.substring(func.indexOf(41) + 1).trim();
                if (customerAlias != null && customerAlias.length() > 0) {
                    String[] asAlias = customerAlias.split(" ");
                    if (asAlias.length > 1) {
                        customerAliasFieldList.add(asAlias[asAlias.length - 1].trim());
                    } else {
                        customerAliasFieldList.add(asAlias[0].trim());
                    }
                } else {
                    customerAliasFieldList.add(null);
                }
                ++sizeFlag;
            }
            this.fields = fieldList.toArray(new String[0]);
            this.funcs = funcList.toArray(new String[0]);
            this.aliasFields = aliasFieldList.toArray(new String[0]);
            this.customerAlias = customerAliasFieldList.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{"param funcs error funcs=" + Arrays.toString(functions)});
        }
    }
}

