/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.orm.dataentity.CRUDHelper;
import kd.bos.orm.dataentity.TableColumnConverterContainer;

public class BatchInsertData {
    private DbMetadataTable _table;
    private List<Object[]> _rows = new ArrayList<Object[]>();
    private List<IColumnValuePair> _oids = new ArrayList<IColumnValuePair>();
    private TableColumnConverterContainer _columnConverter;

    public List<Object[]> getRows() {
        return this._rows;
    }

    public List<IColumnValuePair> getOIds() {
        return this._oids;
    }

    public BatchInsertData(DbMetadataTable table) {
        this._table = table;
        this._columnConverter = CRUDHelper.getTableConverter(table);
    }

    public void insert(IColumnValuePair[] inputValues, IColumnValuePair oid) {
        int columnsCount = this._table.getColumns().size();
        BitSet flag = new BitSet(columnsCount);
        Object[] rowArray = this.createRowArray();
        this._oids.add(oid);
        for (IColumnValuePair columnValue : inputValues) {
            int index = columnValue.getColumn().getColumnIndex();
            rowArray[index] = this._columnConverter.getColumnDbValue(columnValue);
            flag.set(index, true);
        }
        this.setDefaultValue(inputValues, columnsCount, flag, rowArray);
    }

    protected void setDefaultValue(IColumnValuePair[] inputValues, int columnsCount, BitSet flag, Object[] rowArray) {
        if (inputValues.length < columnsCount) {
            for (DbMetadataColumn column : this._table.getColumns()) {
                int index = column.getColumnIndex();
                if (flag.get(index)) continue;
                rowArray[index] = this._columnConverter.getColumnDefaultDbValue(column);
            }
        }
    }

    private Object[] createRowArray() {
        Object[] rowArray = new Object[this._table.getColumns().size()];
        this._rows.add(rowArray);
        return rowArray;
    }

    public DbMetadataTable getTable() {
        return this._table;
    }
}

