/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.IDatabaseTask;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsThreadContext;
import kd.bos.orm.datasync.InsertDataSyncValue;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.context.XDBContext;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;

public class BatchInsertTask
implements IDatabaseTask {
    protected String tableName;
    protected List<Object[]> rows;
    protected List<IColumnValuePair> oids;
    private int level;
    protected DbMetadataColumn[] columns;
    protected DBRoute dbRoute;
    private static final Log log = LogFactory.getLog((String)"BatchInsertTask");

    public BatchInsertTask(DBRoute dbRoute, String tableName, DbMetadataColumn[] columns, int level, List<Object[]> rows, List<IColumnValuePair> oids) {
        this.dbRoute = dbRoute;
        this.tableName = tableName;
        this.rows = rows;
        this.oids = oids;
        this.level = level;
        this.columns = columns;
    }

    @Override
    public int execute() {
        int cols = this.columns.length;
        StringBuilder fields = new StringBuilder(cols * 10);
        StringBuilder parList = new StringBuilder(cols * 2);
        for (DbMetadataColumn column : this.columns) {
            fields.append(column.getName()).append(',');
            parList.append(column.getPlaceholder()).append(',');
        }
        fields.setLength(fields.length() - 1);
        parList.setLength(parList.length() - 1);
        String sql = "/*ORM*/ INSERT INTO " + this.getInsertTableName() + "(" + fields + ") VALUES (" + parList + ")";
        ArrayList<Object[]> psList = new ArrayList<Object[]>(this.rows.size());
        for (Object[] row : this.rows) {
            ArrayList sqlPsList = new ArrayList(cols);
            for (DbMetadataColumn column : this.columns) {
                column.addSqlParameter(sqlPsList, row);
            }
            psList.add(sqlPsList.toArray());
        }
        this.doBatchExecute(sql, psList);
        try {
            if (DtsAccountPower.isAccountDtsEnable() && DataSyncAgent.checkTable((String)this.tableName) && TX.inTX()) {
                DbMetadataTable table = this.columns[0].getTable();
                boolean isLocal = table.isLocale();
                IDataEntityType det = table.getDataEntityTypeMap().getDataEntityType();
                String entityNumber = det.getName();
                String pk = det.getPrimaryKey().getAlias();
                String mainPkName = det.getPrimaryKey().getName();
                if (det.getParent() != null) {
                    IDataEntityType tmpDet = det.getParent();
                    while (tmpDet.getParent() != null) {
                        tmpDet = tmpDet.getParent();
                    }
                    entityNumber = tmpDet.getName();
                    mainPkName = tmpDet.getPrimaryKey().getName();
                }
                String parentPk = null;
                if (isLocal && det.getParent() != null) {
                    parentPk = table.getParentRelation().getChildColumn().getName();
                }
                if (DataSyncAgent.checkEntity((String)entityNumber)) {
                    InsertDataSyncValue value = new InsertDataSyncValue(this.tableName, entityNumber, isLocal);
                    value.setColumnsLs(this.columns, pk, parentPk);
                    value.setRows(this.rows);
                    value.setMainPKName(mainPkName);
                    value.setCount(this.rows.size());
                    DataSyncAgent.get().send(this.dbRoute, OperationType.INSERT, (DataSyncValue)value);
                }
            }
        }
        catch (Exception e) {
            log.error("Dts analyze error!type=insert,sql=" + sql, (Throwable)e);
        }
        return this.rows.size();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    protected String getInsertTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doBatchExecute(String sql, List<Object[]> psList) {
        block46: {
            boolean isInTx = TX.inTX();
            try (DtsThreadContext dtsContext = null;){
                if (isInTx) {
                    dtsContext = DtsThreadContext.create();
                }
                if (ShardingHinter.isSharding(this.tableName)) {
                    if (ShardingHinter.isMainTable(this.tableName)) {
                        ShardingHintContext ctx = ShardingHintContext.get();
                        if (ctx != null && !ctx.isBarrier()) {
                            ctx = ShardingHintContext.createBarrierAndSet();
                            try {
                                DB.executeBatch((DBRoute)this.dbRoute, (String)sql, psList);
                                break block46;
                            }
                            finally {
                                ctx.close();
                            }
                        }
                        DB.executeBatch((DBRoute)this.dbRoute, (String)sql, psList);
                        break block46;
                    }
                    boolean skipHint = false;
                    HashMap<Object, List> paramsListMap = new HashMap<Object, List>();
                    HashMap<Object, ShardingHintContext> ctxMap = new HashMap<Object, ShardingHintContext>();
                    AtomicReference<String> parentPKNameRef = new AtomicReference<String>();
                    ArrayList<Object> rootPkList = new ArrayList<Object>(4);
                    HashSet<Object> rootPkSet = new HashSet<Object>(4);
                    String rootPkField = null;
                    String mainTable = null;
                    boolean isSame = true;
                    DynamicObject preMainEntity = null;
                    int n = this.oids.size();
                    for (int i = 0; i < n; ++i) {
                        IColumnValuePair oid = this.oids.get(i);
                        DynamicObject mainEntity = ShardingHinter.getMainEntity(oid, parentPKNameRef);
                        if (mainEntity == null) {
                            skipHint = true;
                            break;
                        }
                        Object object = mainEntity.getPkValue();
                        rootPkList.add(object);
                        rootPkSet.add(object);
                        if (rootPkField == null) {
                            rootPkField = mainEntity.getDataEntityType().getPrimaryKey().getAlias();
                            mainTable = mainEntity.getDataEntityType().getAlias();
                        }
                        if (isSame) {
                            if (preMainEntity == null) {
                                preMainEntity = mainEntity;
                            }
                            if (preMainEntity.getDataEntityType() != mainEntity.getDataEntityType()) {
                                isSame = false;
                            }
                            preMainEntity = mainEntity;
                        }
                        ctxMap.computeIfAbsent(object, k -> ShardingHinter.tryHint(oid));
                        paramsListMap.computeIfAbsent(object, k -> new ArrayList()).add(psList.get(i));
                    }
                    if (skipHint || ctxMap.isEmpty() || ShardingHintContext.get() != null && ShardingHintContext.get().isHintForTable(this.tableName)) {
                        DB.executeBatch((DBRoute)this.dbRoute, (String)sql, psList);
                        break block46;
                    }
                    HashSet hintTables = new HashSet(3);
                    if (isSame && rootPkField != null) {
                        for (Object[] segpks : ArrayUtil.split((Object[])rootPkSet.toArray(), (int)XDBConfig.get().getQueryIndexBatchSize())) {
                            void var19_28;
                            StringBuilder tryHintSql = new StringBuilder("select ").append(rootPkField).append(" from ").append(mainTable).append(" where ").append(rootPkField).append(" in (");
                            boolean bl = false;
                            int n232 = segpks.length;
                            while (var19_28 < n232) {
                                if (var19_28 != false) {
                                    tryHintSql.append(",");
                                }
                                tryHintSql.append("?");
                                ++var19_28;
                            }
                            tryHintSql.append(")");
                            XDBContext xDBContext = XDB.createContext();
                            Throwable n232 = null;
                            try {
                                xDBContext.addShardingListener(srs -> {
                                    List tableInfoList;
                                    ShardingResult sr = srs[0];
                                    StatementInfo statementInfo = sr.getStatementInfo();
                                    if (statementInfo != null && !(tableInfoList = statementInfo.getTableInfos()).isEmpty()) {
                                        SQLInfo[] sis;
                                        TableInfo tableInfo = (TableInfo)tableInfoList.get(0);
                                        String name = tableInfo.getName();
                                        TableName tableName = TableName.of((String)name);
                                        name = tableName.getAliasName();
                                        for (SQLInfo si : sis = sr.getSQLInfos()) {
                                            String shardSql = si.getSql();
                                            int indexTable = shardSql.indexOf(name);
                                            shardSql = shardSql.substring(indexTable);
                                            int indexOf = shardSql.indexOf(32);
                                            int indexLine = (shardSql = shardSql.substring(0, indexOf)).indexOf("\n");
                                            if (indexLine != -1) {
                                                shardSql = shardSql.substring(0, indexLine);
                                            }
                                            shardSql = shardSql.replaceAll("`", "");
                                            hintTables.add(shardSql);
                                        }
                                    }
                                });
                                DB.query((DBRoute)this.dbRoute, (String)tryHintSql.toString(), (Object[])segpks, rs -> null);
                            }
                            catch (Throwable throwable) {
                                n232 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (xDBContext == null) continue;
                                if (n232 != null) {
                                    try {
                                        xDBContext.close();
                                    }
                                    catch (Throwable throwable) {
                                        n232.addSuppressed(throwable);
                                    }
                                    continue;
                                }
                                xDBContext.close();
                            }
                        }
                    }
                    if (isSame) {
                        HashMap<Object, List> indexParamsListMap = new HashMap<Object, List>();
                        HashMap<Object, Set> indexPkListMap = new HashMap<Object, Set>();
                        if (hintTables.size() == 1) {
                            indexPkListMap.put(-1, rootPkSet);
                            indexParamsListMap.put(-1, psList);
                        } else {
                            void var19_31;
                            Map<Object, Long> pkIndexMap = ShardingHinter.queryShardingIndex(this.dbRoute, mainTable, Arrays.asList(rootPkSet.toArray()));
                            boolean bl = false;
                            int N = rootPkList.size();
                            while (var19_31 < N) {
                                Object pk = rootPkList.get((int)var19_31);
                                long index = null != pkIndexMap.get(pk) ? (Long)pkIndexMap.get(pk) : -1L;
                                Object[] params = psList.get((int)var19_31);
                                indexPkListMap.computeIfAbsent(index, k -> new HashSet()).add(pk);
                                indexParamsListMap.computeIfAbsent(index, k -> new ArrayList()).add(params);
                                ++var19_31;
                            }
                        }
                        for (Map.Entry entry : indexPkListMap.entrySet()) {
                            Set pks = (Set)entry.getValue();
                            List paramsList = (List)indexParamsListMap.get(entry.getKey());
                            ShardingHintContext ctx = ShardingHinter.tryHint(mainTable, rootPkField, Arrays.asList(pks.toArray()));
                            if (ctx == null) continue;
                            ctx.set();
                            try {
                                DB.executeBatch((DBRoute)this.dbRoute, (String)sql, (List)paramsList);
                            }
                            finally {
                                ctx.close();
                            }
                        }
                    } else {
                        for (Map.Entry entry : ctxMap.entrySet()) {
                            ShardingHintContext ctx = (ShardingHintContext)entry.getValue();
                            List list = (List)paramsListMap.get(entry.getKey());
                            if (ctx != null) {
                                ctx.set();
                                try {
                                    DB.executeBatch((DBRoute)this.dbRoute, (String)sql, (List)list);
                                    continue;
                                }
                                finally {
                                    ctx.close();
                                    continue;
                                }
                            }
                            DB.executeBatch((DBRoute)this.dbRoute, (String)sql, (List)list);
                        }
                    }
                    break block46;
                }
                DB.executeBatch((DBRoute)this.dbRoute, (String)sql, psList);
            }
        }
    }
}

