/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.dataentity.BatchInsertData;
import kd.bos.orm.dataentity.BatchInsertShardingTask;
import kd.bos.orm.dataentity.BatchInsertTask;
import kd.bos.orm.dataentity.CRUDHelper;
import kd.bos.orm.dataentity.IDatabaseTask;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchInsertTaskContainer {
    Logger log = LoggerFactory.getLogger(BatchInsertTaskContainer.class);
    private Map<DbMetadataTable, BatchInsertData> _dataSet = new HashMap<DbMetadataTable, BatchInsertData>();
    private Tuple<DbMetadataTable, BatchInsertData> _last;
    private DBRoute dbRoute;

    public BatchInsertTaskContainer(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public void insert(DbMetadataTable table, IColumnValuePair[] inputValues, IColumnValuePair oid) {
        this.getBatchInsertData(table).insert(inputValues, oid);
    }

    private BatchInsertData getBatchInsertData(DbMetadataTable table) {
        if (this._last != null && this._last.item1 == table) {
            return (BatchInsertData)this._last.item2;
        }
        BatchInsertData task = this._dataSet.get(table);
        if (task == null) {
            task = new BatchInsertData(table);
            this._dataSet.put(table, task);
        }
        this._last = new Tuple((Object)table, (Object)task);
        return task;
    }

    public IDatabaseTask[] createTasks() {
        ArrayList<BatchInsertTask> result = new ArrayList<BatchInsertTask>();
        Long shardingTableIndex = this.readShardingTableIndex();
        for (BatchInsertData data : this._dataSet.values()) {
            DbMetadataTable table = data.getTable();
            int tableLevel = CRUDHelper.getTableLevel(table);
            List columnsByTableGroup = table.getColumnsByTableGroup();
            for (Tuple group : columnsByTableGroup) {
                String groupName = (String)group.item1;
                DbMetadataColumn[] columns = (DbMetadataColumn[])group.item2;
                if (CRUDHelper.getExTableHaveRelitionField() && table.getParentRelation() != null && StringUtils.isNotBlank((CharSequence)groupName)) {
                    DbMetadataColumn[] columns2 = new DbMetadataColumn[columns.length + 1];
                    System.arraycopy(columns, 0, columns2, 0, columns.length);
                    columns2[columns.length] = table.getParentRelation().getChildColumn();
                    columns = columns2;
                }
                int level = tableLevel * 2 - (StringUtils.isBlank((CharSequence)groupName) ? 1 : 0);
                String tableName = CRUDHelper.getTableNameWithGroup(table.getName(), groupName);
                if (shardingTableIndex == null || ShardingHinter.isMainTable(tableName) || !DB.isSharded((String)tableName)) {
                    BatchInsertTask task = new BatchInsertTask(this.dbRoute, tableName, columns, level, data.getRows(), data.getOIds());
                    result.add(task);
                    continue;
                }
                String shardingTableName = TableName.of((String)tableName).getShardingTable(shardingTableIndex.longValue());
                BatchInsertShardingTask task = new BatchInsertShardingTask(this.dbRoute, tableName, shardingTableName, columns, level, data.getRows(), data.getOIds());
                result.add(task);
            }
        }
        return result.toArray(new IDatabaseTask[result.size()]);
    }

    private Long readShardingTableIndex() {
        ShardingHintContext ctx;
        DbMetadataTable rootTable = null;
        for (BatchInsertData data : this._dataSet.values()) {
            DbMetadataTable table = data.getTable();
            if (table.getParentRelation() != null) continue;
            rootTable = table;
            break;
        }
        if (rootTable == null || !DB.isXDBEnable()) {
            return null;
        }
        if (XDBConfig.get().isParseSkip() && (ctx = ShardingHintContext.get()) != null && !ctx.isSkipHint()) {
            try {
                return (Long)DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.dbRoute, (boolean)false, () -> {
                    ShardingConfig hintConfig = ctx.findHintConfig();
                    long[] shardingIndex = ctx.tryShardingIndex(hintConfig);
                    if (shardingIndex != null && shardingIndex.length == 1) {
                        return shardingIndex[0];
                    }
                    return null;
                });
            }
            catch (Exception e) {
                this.log.error("readShardingTableIndex error:" + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

