/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.BatchInsertTask;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.DtsThreadContext;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.UpdateDataSyncValue;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.xdb.hint.ShardingHintContext;

public class BatchUpdateTask
extends BatchInsertTask {
    protected DbMetadataColumn primaryKey;
    protected List<Object> ids;
    protected List<ISaveMetaRow> saveRows;
    private static final Log log = LogFactory.getLog((String)"BatchUpdateTask");

    public BatchUpdateTask(DBRoute dbRoute, String tableNameWithGroup, DbMetadataColumn[] columns, List<Object[]> rows, List<IColumnValuePair> oids, DbMetadataColumn primaryKey, List<Object> ids, List<ISaveMetaRow> saveRows, int level) {
        super(dbRoute, tableNameWithGroup, columns, level, rows, oids);
        this.primaryKey = primaryKey;
        this.ids = ids;
        this.saveRows = saveRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() {
        int[] result;
        boolean isInTx;
        String sql;
        block20: {
            StringBuilder fields = new StringBuilder();
            for (DbMetadataColumn column : this.columns) {
                fields.append(column.getName()).append('=').append(column.getPlaceholder()).append(',');
            }
            fields.deleteCharAt(fields.length() - 1);
            sql = "UPDATE " + this.tableName + " SET " + fields + " WHERE " + this.primaryKey.getName() + "=?";
            ArrayList<Object[]> listParas = new ArrayList<Object[]>(this.rows.size());
            int j = 0;
            for (Object[] row : this.rows) {
                ArrayList<SqlParameter> sqlPsList = new ArrayList<SqlParameter>(this.columns.length + 1);
                for (DbMetadataColumn column : this.columns) {
                    column.addSqlParameter(sqlPsList, row);
                }
                sqlPsList.add(new SqlParameter(this.primaryKey.getName(), this.primaryKey.getDbType(), this.ids.get(j)));
                listParas.add(sqlPsList.toArray());
                ++j;
            }
            isInTx = TX.inTX();
            result = null;
            try (DtsThreadContext dtsContext = null;){
                ShardingHintContext ctx;
                if (isInTx) {
                    dtsContext = DtsThreadContext.create();
                }
                if ((ctx = ShardingHinter.tryHint(this.tableName, this.saveRows.toArray(new ISaveMetaRow[this.saveRows.size()]))) != null) {
                    ctx.set();
                    try {
                        result = DB.executeBatch((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), listParas);
                        break block20;
                    }
                    finally {
                        ctx.close();
                    }
                }
                result = DB.executeBatch((DBRoute)this.dbRoute, (String)("/*ORM*/ " + sql), listParas);
            }
        }
        try {
            if (DtsAccountPower.isAccountDtsEnable() && DataSyncAgent.checkTable((String)this.tableName) && isInTx) {
                DbMetadataTable table = this.columns[0].getTable();
                boolean isLocal = table.isLocale();
                IDataEntityType det = table.getDataEntityTypeMap().getDataEntityType();
                String entityNumber = det.getName();
                String pk = det.getPrimaryKey().getAlias();
                String mainPkName = det.getPrimaryKey().getName();
                if (det.getParent() != null) {
                    IDataEntityType tmpDet = det.getParent();
                    while (tmpDet.getParent() != null) {
                        tmpDet = tmpDet.getParent();
                    }
                    entityNumber = tmpDet.getName();
                    mainPkName = tmpDet.getPrimaryKey().getName();
                }
                if (DataSyncAgent.checkEntity((String)entityNumber)) {
                    UpdateDataSyncValue value = new UpdateDataSyncValue(this.tableName, entityNumber, isLocal);
                    value.setColumnsLs(this.columns);
                    value.setRows(this.rows);
                    value.setTableOids(this.ids);
                    value.setTablePkField(this.primaryKey);
                    value.setTablePkFieldStr(pk);
                    value.setMainPKName(mainPkName);
                    value.setCount(this.rows.size());
                    if (isLocal && det.getParent() != null) {
                        DbMetadataColumn entityPKColumn = table.getParentRelation().getChildColumn();
                        String parentPk = entityPKColumn.getName();
                        DbMetadataColumn localCol = this.saveRows.get(0).getLocale().getColumn();
                        ArrayList<Object> pids = new ArrayList<Object>(this.rows.size());
                        for (int ind = 0; ind < this.rows.size(); ++ind) {
                            Object[] row = (Object[])this.rows.get(ind);
                            row[localCol.getColumnIndex()] = this.saveRows.get(ind).getLocale().getValue();
                            pids.add(this.saveRows.get(ind).getParentOid().getValue());
                        }
                        value.addColumn(localCol);
                        value.setEntityPkFieldStr(parentPk);
                        value.setEntityOids(pids);
                        value.setEntityPkField(entityPKColumn);
                        value.setCount(pids.size());
                    }
                    DataSyncAgent.get().send(this.dbRoute, OperationType.UPDATE, (DataSyncValue)value);
                }
            }
        }
        catch (Exception e) {
            log.error("Dts analyze error!type=update,sql=" + sql, (Throwable)e);
        }
        this.analyseUpdateResult(result, this.rows);
        return this.rows.size();
    }

    protected void analyseUpdateResult(int[] result, List<Object[]> rows) {
    }

    @Override
    public int getLevel() {
        return 0;
    }
}

